# OAuth2.0 认证步骤详解

## 🎯 完整认证流程

### 步骤1: 准备阶段

#### 1.1 获取Shoplazza应用凭证
```
1. 访问 https://partners.shoplazza.com/
2. 登录并创建新应用
3. 记录 CLIENT_ID 和 CLIENT_SECRET
```

#### 1.2 设置本地开发环境
```bash
# 安装依赖
pip install -r requirements.txt

# 安装ngrok (用于本地开发)
npm install -g ngrok
```

#### 1.3 启动ngrok隧道
```bash
# 在终端1中启动ngrok
ngrok http 3000

# 记录ngrok提供的HTTPS URL，例如：
# https://abc123.ngrok.io
```

### 步骤2: 配置应用

#### 2.1 创建环境配置文件
创建 `.env` 文件：
```env
CLIENT_ID=your_actual_client_id_from_shoplazza
CLIENT_SECRET=your_actual_client_secret_from_shoplazza
BASE_URL=https://abc123.ngrok.io
REDIRECT_URI=/auth/shoplazza/callback
SECRET_KEY=your-random-secret-key
FLASK_ENV=development
FLASK_DEBUG=True
PORT=3000
```

#### 2.2 在Shoplazza开发者中心配置URL
```
应用URL: https://abc123.ngrok.io/auth/install
回调URL: https://abc123.ngrok.io/auth/shoplazza/callback
Webhook URL: https://abc123.ngrok.io/webhook/shoplazza
```

### 步骤3: 启动应用

```bash
# 在终端2中启动应用
python run.py
```

您应该看到类似输出：
```
🚀 启动 Shoplazza OAuth2.0 后端服务...
📡 服务地址: http://localhost:3000
🔗 认证端点: https://abc123.ngrok.io/auth/install?shop=your-shop.myshoplaza.com
📋 API文档: https://abc123.ngrok.io/
```

### 步骤4: 执行OAuth认证

#### 4.1 开始认证流程
在浏览器中访问：
```
https://abc123.ngrok.io/auth/install?shop=your-shop.myshoplaza.com
```

**注意**: 将 `your-shop.myshoplaza.com` 替换为实际的商店域名

#### 4.2 授权确认
1. 系统会重定向到Shoplazza授权页面
2. 商家点击"安装应用"或"授权"
3. 系统自动处理回调

#### 4.3 验证认证结果
访问以下URL查看认证状态：
```
https://abc123.ngrok.io/auth/tokens
```

### 步骤5: 测试API调用

#### 5.1 获取客户列表
```bash
curl https://abc123.ngrok.io/api/customers/your-shop.myshoplaza.com
```

#### 5.2 获取产品列表
```bash
curl https://abc123.ngrok.io/api/products/your-shop.myshoplaza.com
```

#### 5.3 获取订单列表
```bash
curl https://abc123.ngrok.io/api/orders/your-shop.myshoplaza.com
```

#### 5.4 获取商店信息
```bash
curl https://abc123.ngrok.io/api/shop_info/your-shop.myshoplaza.com
```

## 🔍 认证流程详解

### OAuth2.0 流程图
```
商家 → 应用安装 → 授权页面 → 确认授权 → 回调处理 → 获取令牌 → API调用
```

### 详细步骤说明

1. **应用安装请求**
   - 商家从应用商店安装应用
   - Shoplazza发送请求到 `/auth/install`
   - 应用重定向到Shoplazza授权页面

2. **用户授权**
   - 商家在Shoplazza页面确认授权
   - 选择需要的权限范围
   - 点击"安装应用"

3. **授权回调**
   - Shoplazza重定向到 `/auth/shoplazza/callback`
   - 携带授权码和HMAC签名
   - 应用验证HMAC签名

4. **令牌交换**
   - 应用使用授权码请求访问令牌
   - Shoplazza返回访问令牌和刷新令牌
   - 应用存储令牌用于后续API调用

5. **API调用**
   - 使用访问令牌调用Shoplazza API
   - 获取客户、产品、订单等数据

## 🛠️ 故障排除

### 常见错误及解决方案

1. **"Missing HMAC parameter"**
   - 检查请求是否来自Shoplazza
   - 确认URL参数完整

2. **"HMAC validation failed"**
   - 检查CLIENT_SECRET配置
   - 确认请求参数顺序正确

3. **"Shop not authorized"**
   - 确认已完成OAuth认证
   - 检查访问令牌是否有效

4. **"Failed to obtain access token"**
   - 检查CLIENT_ID和CLIENT_SECRET
   - 确认回调URL配置正确

### 调试命令

```bash
# 检查应用状态
curl https://abc123.ngrok.io/health

# 查看已授权的商店
curl https://abc123.ngrok.io/auth/tokens

# 刷新访问令牌
curl https://abc123.ngrok.io/auth/refresh_token/your-shop.myshoplaza.com
```

## 📝 注意事项

1. **HTTPS要求**: 生产环境必须使用HTTPS
2. **令牌安全**: 生产环境应使用数据库存储令牌
3. **错误处理**: 实现适当的错误处理和日志记录
4. **权限范围**: 只请求应用实际需要的权限
5. **令牌刷新**: 定期刷新访问令牌以保持有效性
