#!/usr/bin/env python3
"""
Shoplazza OAuth2.0 后端应用启动脚本
"""

import os
import sys
from app import create_app

def main():
    """主函数"""
    # 检查环境变量
    required_vars = ['CLIENT_ID', 'CLIENT_SECRET', 'BASE_URL']
    missing_vars = [var for var in required_vars if not os.getenv(var)]
    
    if missing_vars:
        print(f"错误: 缺少必需的环境变量: {', '.join(missing_vars)}")
        print("请创建 .env 文件并配置以下变量:")
        print("CLIENT_ID=your_client_id_here")
        print("CLIENT_SECRET=your_client_secret_here")
        print("BASE_URL=https://your-domain.com")
        sys.exit(1)
    
    # 创建应用
    app = create_app()
    
    # 启动应用
    print("🚀 启动 Shoplazza OAuth2.0 后端服务...")
    print(f"📡 服务地址: http://localhost:{app.config['PORT']}")
    print(f"🔗 认证端点: {app.config['BASE_URL']}/auth/install?shop=your-shop.myshoplaza.com")
    print(f"📋 API文档: {app.config['BASE_URL']}/")
    
    app.run(
        host='0.0.0.0',
        port=app.config['PORT'],
        debug=app.config['DEBUG']
    )

if __name__ == '__main__':
    main()
