import os
from dotenv import load_dotenv

# 加载环境变量
load_dotenv()

class Config:
    """Shoplazza OAuth2.0 应用配置"""
    
    # Shoplazza OAuth2.0 配置
    CLIENT_ID = os.getenv('CLIENT_ID', 'your_client_id_here')
    CLIENT_SECRET = os.getenv('CLIENT_SECRET', 'your_client_secret_here')
    BASE_URL = os.getenv('BASE_URL', 'https://your-domain.com')
    REDIRECT_URI = os.getenv('REDIRECT_URI', '/auth/shoplazza/callback')
    
    # Flask 配置
    SECRET_KEY = os.getenv('SECRET_KEY', 'your-secret-key-here')
    DEBUG = os.getenv('FLASK_DEBUG', 'True').lower() == 'true'
    PORT = int(os.getenv('PORT', 3000))
    
    # 存储访问令牌的字典（生产环境应使用数据库）
    ACCESS_TOKENS = {}
