# Shoplazza OAuth2.0 后端应用

这是一个基于Python Flask的Shoplazza OAuth2.0认证后端应用，实现了完整的OAuth2.0认证流程和API调用功能。

## 功能特性

- ✅ OAuth2.0 认证流程
- ✅ HMAC 签名验证
- ✅ 访问令牌管理
- ✅ 令牌刷新功能
- ✅ Shoplazza API 调用
- ✅ Webhook 处理
- ✅ 安全验证中间件

## 项目结构

```
├── app.py                 # 主应用入口
├── config.py             # 配置文件
├── requirements.txt      # 依赖包
├── middleware/
│   └── hmac_validator.py # HMAC验证中间件
├── routes/
│   ├── auth.py           # 认证路由
│   ├── api.py            # API调用路由
│   └── webhook.py        # Webhook处理路由
└── README.md             # 项目说明
```

## 安装和配置

### 1. 安装依赖

```bash
pip install -r requirements.txt
```

### 2. 环境配置

创建 `.env` 文件并配置以下参数：

```env
# Shoplazza OAuth2.0 配置
CLIENT_ID=your_client_id_here
CLIENT_SECRET=your_client_secret_here
BASE_URL=https://your-domain.com
REDIRECT_URI=/auth/shoplazza/callback

# 应用配置
FLASK_ENV=development
FLASK_DEBUG=True
PORT=3000
SECRET_KEY=your-secret-key-here
```

### 3. 运行应用

```bash
python app.py
```

## API 端点

### 认证端点

- `GET /auth/install?shop=your-shop.myshoplaza.com` - 开始OAuth认证流程
- `GET /auth/shoplazza/callback` - OAuth回调处理
- `GET /auth/refresh_token/<shop>` - 刷新访问令牌
- `GET /auth/tokens` - 查看已授权的商店令牌

### API调用端点

- `GET /api/customers/<shop>` - 获取客户列表
- `GET /api/products/<shop>` - 获取产品列表
- `GET /api/orders/<shop>` - 获取订单列表
- `GET /api/shop_info/<shop>` - 获取商店信息

### Webhook端点

- `POST /webhook/shoplazza` - 处理Shoplazza Webhook

## 使用示例

### 1. 开始认证流程

访问以下URL开始OAuth认证：
```
https://your-domain.com/auth/install?shop=your-shop.myshoplaza.com
```

### 2. 调用API

认证成功后，可以调用Shoplazza API：
```bash
curl https://your-domain.com/api/customers/your-shop.myshoplaza.com
```

### 3. 处理Webhook

在Shoplazza开发者中心配置Webhook URL：
```
https://your-domain.com/webhook/shoplazza
```

## OAuth2.0 认证流程

1. **应用安装**: 商家从应用商店安装应用
2. **授权请求**: 应用重定向到Shoplazza授权页面
3. **用户授权**: 商家确认授权
4. **授权回调**: Shoplazza重定向回应用并携带授权码
5. **令牌交换**: 应用使用授权码交换访问令牌
6. **API调用**: 使用访问令牌调用Shoplazza API

## 安全特性

- HMAC签名验证确保请求来自Shoplazza
- 安全的令牌存储和管理
- CSRF攻击防护
- Webhook签名验证

## 开发说明

### 本地开发

1. 使用ngrok等工具将本地服务暴露到公网
2. 在Shoplazza开发者中心配置应用URL
3. 确保所有回调URL使用HTTPS

### 生产部署

1. 使用环境变量管理敏感配置
2. 使用数据库存储访问令牌
3. 配置适当的日志记录
4. 设置监控和告警

## 故障排除

### 常见问题

1. **HMAC验证失败**: 检查CLIENT_SECRET配置
2. **授权失败**: 确认回调URL配置正确
3. **API调用失败**: 检查访问令牌是否有效

### 日志查看

应用会记录详细的日志信息，包括：
- 认证流程状态
- API调用结果
- 错误信息

## 许可证

MIT License
