# 项目结构说明

## 文件组织

```
shoplazza-oauth-backend/
├── app.py                    # 主应用入口
├── config.py                 # 配置管理
├── run.py                    # 启动脚本
├── requirements.txt          # Python依赖
├── env_template.txt          # 环境变量模板
├── README.md                 # 项目文档
├── PROJECT_STRUCTURE.md     # 项目结构说明
├── middleware/
│   └── hmac_validator.py     # HMAC验证中间件
└── routes/
    ├── auth.py              # OAuth2.0认证路由
    ├── api.py               # Shoplazza API调用
    └── webhook.py           # Webhook处理
```

## 核心组件

### 1. 配置管理 (config.py)
- 环境变量加载
- 应用配置管理
- 访问令牌存储

### 2. HMAC验证 (middleware/hmac_validator.py)
- OAuth请求HMAC验证
- Webhook签名验证
- 安全比较函数

### 3. 认证流程 (routes/auth.py)
- 应用安装处理
- OAuth回调处理
- 令牌交换和刷新

### 4. API调用 (routes/api.py)
- 客户数据获取
- 产品数据获取
- 订单数据获取
- 商店信息获取

### 5. Webhook处理 (routes/webhook.py)
- Webhook签名验证
- 事件处理逻辑
- 应用卸载处理

## 数据流

```
1. 商家安装应用
   ↓
2. 重定向到Shoplazza授权页面
   ↓
3. 商家确认授权
   ↓
4. Shoplazza回调应用
   ↓
5. HMAC验证
   ↓
6. 交换访问令牌
   ↓
7. 存储令牌
   ↓
8. 调用Shoplazza API
```

## 安全特性

- HMAC签名验证
- CSRF攻击防护
- 安全的令牌存储
- Webhook签名验证
- 环境变量配置管理
