# Shoplazza OAuth2.0 认证设置指南

## 第一步：获取应用凭证

1. **访问Shoplazza开发者平台**
   - 打开 https://partners.shoplazza.com/
   - 登录您的账户

2. **创建新应用**
   - 点击"创建应用"
   - 选择"公共应用"
   - 填写应用信息

3. **获取凭证**
   - 复制 `CLIENT_ID`
   - 复制 `CLIENT_SECRET`

## 第二步：配置本地环境

### 1. 安装依赖
```bash
pip install -r requirements.txt
```

### 2. 创建环境配置文件
创建 `.env` 文件：
```env
# Shoplazza OAuth2.0 配置
CLIENT_ID=your_actual_client_id
CLIENT_SECRET=your_actual_client_secret
BASE_URL=https://your-ngrok-url.ngrok.io
REDIRECT_URI=/auth/shoplazza/callback

# Flask 应用配置
SECRET_KEY=your-secret-key-here
FLASK_ENV=development
FLASK_DEBUG=True
PORT=3000
```

### 3. 使用ngrok暴露本地服务
```bash
# 安装ngrok
npm install -g ngrok

# 启动ngrok
ngrok http 3000

# 复制ngrok提供的HTTPS URL到BASE_URL
```

## 第三步：配置Shoplazza应用

在Shoplazza开发者中心配置以下URL：

1. **应用URL**: `https://your-ngrok-url.ngrok.io/auth/install`
2. **回调URL**: `https://your-ngrok-url.ngrok.io/auth/shoplazza/callback`
3. **Webhook URL**: `https://your-ngrok-url.ngrok.io/webhook/shoplazza`

## 第四步：启动应用

```bash
python run.py
```

## 第五步：测试OAuth流程

### 1. 开始认证
访问以下URL（替换为实际的商店域名）：
```
https://your-ngrok-url.ngrok.io/auth/install?shop=your-shop.myshoplaza.com
```

### 2. 完成授权
- 系统会重定向到Shoplazza授权页面
- 商家确认授权
- 系统自动处理回调并获取访问令牌

### 3. 测试API调用
```bash
# 获取客户列表
curl https://your-ngrok-url.ngrok.io/api/customers/your-shop.myshoplaza.com

# 获取产品列表
curl https://your-ngrok-url.ngrok.io/api/products/your-shop.myshoplaza.com
```

## 故障排除

### 常见问题

1. **HMAC验证失败**
   - 检查CLIENT_SECRET是否正确
   - 确认请求来自Shoplazza

2. **授权失败**
   - 检查回调URL配置
   - 确认BASE_URL使用HTTPS

3. **API调用失败**
   - 检查访问令牌是否有效
   - 确认权限范围正确

### 调试技巧

1. **查看日志**
   ```bash
   # 应用会输出详细的日志信息
   python run.py
   ```

2. **检查令牌状态**
   ```bash
   curl https://your-ngrok-url.ngrok.io/auth/tokens
   ```

3. **健康检查**
   ```bash
   curl https://your-ngrok-url.ngrok.io/health
   ```
