#!/bin/bash

echo "======================================================================"
echo "测试修复是否成功"
echo "======================================================================"
echo ""

cd /home/tw/recommendation/offline_tasks

# 测试 1: 检查文件结构
echo "[测试 1] 检查文件结构..."
if [ -f "db_service.py" ]; then
    echo "  ✓ db_service.py 在 offline_tasks/ 根目录"
else
    echo "  ✗ db_service.py 未找到"
    exit 1
fi

if [ -f "config/offline_config.py" ]; then
    echo "  ✓ config/offline_config.py 存在"
else
    echo "  ✗ config/offline_config.py 未找到"
    exit 1
fi

if [ -f "deepwalk/deepwalk.py" ] && [ -f "deepwalk/alias.py" ]; then
    echo "  ✓ DeepWalk 文件已移动到 offline_tasks/deepwalk/"
else
    echo "  ✗ DeepWalk 文件未找到"
    exit 1
fi

# 测试 2: 检查 Python 语法
echo ""
echo "[测试 2] 检查 Python 脚本语法..."
python3 -m py_compile scripts/i2i_item_behavior.py 2>/dev/null
if [ $? -eq 0 ]; then
    echo "  ✓ i2i_item_behavior.py 语法正确"
else
    echo "  ✗ i2i_item_behavior.py 语法错误"
    exit 1
fi

python3 -m py_compile scripts/tag_category_similar.py 2>/dev/null
if [ $? -eq 0 ]; then
    echo "  ✓ tag_category_similar.py 语法正确"
else
    echo "  ✗ tag_category_similar.py 语法错误"
    exit 1
fi

python3 -m py_compile scripts/i2i_deepwalk.py 2>/dev/null
if [ $? -eq 0 ]; then
    echo "  ✓ i2i_deepwalk.py 语法正确"
else
    echo "  ✗ i2i_deepwalk.py 语法错误"
    exit 1
fi

python3 -m py_compile scripts/fetch_item_attributes.py 2>/dev/null
if [ $? -eq 0 ]; then
    echo "  ✓ fetch_item_attributes.py 语法正确"
else
    echo "  ✗ fetch_item_attributes.py 语法错误"
    exit 1
fi

python3 -m py_compile scripts/generate_session.py 2>/dev/null
if [ $? -eq 0 ]; then
    echo "  ✓ generate_session.py 语法正确"
else
    echo "  ✗ generate_session.py 语法错误"
    exit 1
fi

# 测试 3: 检查是否还有 sys.path hack
echo ""
echo "[测试 3] 检查是否清理了 sys.path hack..."
sys_path_count=$(grep -r "sys.path.append" scripts/*.py 2>/dev/null | wc -l)
if [ $sys_path_count -eq 0 ]; then
    echo "  ✓ 所有 sys.path hack 已清理"
else
    echo "  ⚠️  仍有 $sys_path_count 个文件包含 sys.path.append"
    grep -r "sys.path.append" scripts/*.py
fi

# 测试 4: 检查导入语句
echo ""
echo "[测试 4] 检查导入语句..."
if grep -q "^from db_service import" scripts/i2i_item_behavior.py; then
    echo "  ✓ i2i_item_behavior.py 正确导入 db_service"
else
    echo "  ✗ i2i_item_behavior.py 未导入 db_service"
    exit 1
fi

if grep -q "^from config.offline_config import" scripts/fetch_item_attributes.py; then
    echo "  ✓ fetch_item_attributes.py 正确导入 config.offline_config"
else
    echo "  ✗ fetch_item_attributes.py 未导入 config.offline_config"
    exit 1
fi

if grep -q "^from scripts.debug_utils import" scripts/fetch_item_attributes.py; then
    echo "  ✓ fetch_item_attributes.py 正确导入 scripts.debug_utils"
else
    echo "  ✗ fetch_item_attributes.py 未导入 scripts.debug_utils"
    exit 1
fi

if grep -q "^from deepwalk.deepwalk import DeepWalk" scripts/i2i_deepwalk.py; then
    echo "  ✓ i2i_deepwalk.py 正确导入 deepwalk.deepwalk.DeepWalk"
else
    echo "  ✗ i2i_deepwalk.py 未导入 deepwalk.deepwalk.DeepWalk"
    exit 1
fi

# 测试 5: 检查 run.sh 是否设置了 PYTHONPATH
echo ""
echo "[测试 5] 检查 run.sh 配置..."
if grep -q "export PYTHONPATH" run.sh; then
    echo "  ✓ run.sh 已设置 PYTHONPATH"
else
    echo "  ⚠️  run.sh 未设置 PYTHONPATH"
fi

echo ""
echo "======================================================================"
echo "✓ 所有测试通过！"
echo "======================================================================"
echo ""
echo "文件结构:"
echo "  offline_tasks/  (Python 根目录)"
echo "    ├── db_service.py"
echo "    ├── config/offline_config.py"
echo "    ├── deepwalk/deepwalk.py, alias.py"
echo "    ├── scripts/*.py"
echo "    └── run.sh (设置了 PYTHONPATH)"
echo ""
echo "现在可以运行："
echo "  cd /home/tw/recommendation/offline_tasks"
echo "  bash run.sh"
echo ""
