#!/bin/bash
# 推荐系统离线任务安装脚本

echo "========================================"
echo "推荐系统离线任务 - 安装脚本"
echo "========================================"
echo ""

# 检查Python版本
echo "检查Python版本..."
python_version=$(python3 --version 2>&1 | awk '{print $2}')
echo "当前Python版本: $python_version"

if ! command -v python3 &> /dev/null; then
    echo "错误: 未找到Python3，请先安装Python3"
    exit 1
fi

# 检查pip
echo ""
echo "检查pip..."
if ! command -v pip3 &> /dev/null; then
    echo "错误: 未找到pip3，请先安装pip3"
    exit 1
fi

# 创建必要的目录
echo ""
echo "创建目录结构..."
mkdir -p output
mkdir -p logs
echo "✓ 目录创建完成"

# 安装依赖包
echo ""
echo "安装Python依赖包..."
echo "这可能需要几分钟时间..."
pip3 install -r ../requirements.txt

if [ $? -eq 0 ]; then
    echo "✓ 依赖包安装完成"
else
    echo "✗ 依赖包安装失败，请检查错误信息"
    exit 1
fi

# 测试连接
echo ""
echo "测试数据库和Redis连接..."
python3 test_connection.py

echo ""
echo "========================================"
echo "安装完成！"
echo "========================================"
echo ""
echo "接下来的步骤："
echo "1. 检查配置文件: config/offline_config.py"
echo "2. 运行测试: python3 test_connection.py"
echo "3. 运行离线任务: python3 run_all.py --lookback_days 730 --top_n 50"
echo ""
echo "详细文档请查看:"
echo "  - QUICKSTART.md (快速开始)"
echo "  - README.md (详细文档)"
echo "  - PROJECT_SUMMARY.md (项目总结)"
echo ""

