# 离线索引产出规范

## 📋 索引任务列表

| 模块名称 | 任务命令 | 调度频次 | 输出数据 | 格式和示例 |
|---------|---------|---------|---------|-----------|
| **i2i_swing_cpp** | `cd offline_tasks/collaboration && bash run.sh` | 每天 | `offline_tasks/collaboration/output/swing_similar.txt` | `item_id \t similar_id1:score1,similar_id2:score2,...` |
| **i2i_swing** | `python3 scripts/i2i_swing.py` | 每天 | `output/i2i_swing_YYYYMMDD.txt` | `item_id \t item_name \t similar_id1:score1,similar_id2:score2,...` |
| **i2i_session_w2v** | `python3 scripts/i2i_session_w2v.py` | 每天 | `output/i2i_session_w2v_YYYYMMDD.txt` | `item_id \t item_name \t similar_id1:score1,similar_id2:score2,...` |
| **i2i_deepwalk** | `python3 scripts/i2i_deepwalk.py` | 每天 | `output/i2i_deepwalk_YYYYMMDD.txt` | `item_id \t item_name \t similar_id1:score1,similar_id2:score2,...` |
| **i2i_content** | `python3 scripts/i2i_content_similar.py` | 每周 | `output/i2i_content_hybrid_YYYYMMDD.txt` | `item_id \t item_name \t similar_id1:score1,similar_id2:score2,...` |
| **interest_hot** | `python3 scripts/interest_aggregation.py` | 每天 | `output/interest_aggregation_hot_YYYYMMDD.txt` | `dimension_key \t item_id1,item_id2,item_id3,...` |
| **interest_cart** | `python3 scripts/interest_aggregation.py` | 每天 | `output/interest_aggregation_cart_YYYYMMDD.txt` | `dimension_key \t item_id1,item_id2,item_id3,...` |
| **interest_new** | `python3 scripts/interest_aggregation.py` | 每天 | `output/interest_aggregation_new_YYYYMMDD.txt` | `dimension_key \t item_id1,item_id2,item_id3,...` |
| **interest_global** | `python3 scripts/interest_aggregation.py` | 每天 | `output/interest_aggregation_global_YYYYMMDD.txt` | `dimension_key \t item_id1,item_id2,item_id3,...` |

## 📊 详细格式说明

### 1. i2i相似度索引

#### 1.1 C++ Swing算法（高性能版本）

**输出格式**
```
item_id \t similar_id1:score1,similar_id2:score2,...
```

**示例**
```
3600052	2704531:0.00431593,2503886:0.00431593,3371410:0.00431593,3186572:0.00431593
2704531	3600052:0.00431593,2503886:0.00863186,3371410:0.00431593
```

**字段说明**
- `item_id`: 商品SKU ID
- `similar_id`: 相似商品ID
- `score`: 相似度分数（原始Swing分数，范围不固定）

**特点**
- ⚡ **高性能**: C++实现，速度比Python快10-100倍
- 📊 **大规模**: 适合处理10万+商品的相似度计算
- 🔢 **原始分数**: 输出Swing算法原始分数（未归一化）
- 📁 **文件位置**: `offline_tasks/collaboration/output/swing_similar.txt`
- 📝 **可读版本**: `offline_tasks/collaboration/output/swing_similar_readable.txt` (包含商品名称)

#### 1.2 Python算法（标准版本）

**输出格式**
```
item_id \t item_name \t similar_id1:score1,similar_id2:score2,...
```

**示例**
```
12345	香蕉干	67890:0.8567,11223:0.7234,44556:0.6891
67890	芒果干	12345:0.8567,22334:0.7123,55667:0.6543
```

**字段说明**
- `item_id`: 商品SKU ID
- `item_name`: 商品名称
- `similar_id`: 相似商品ID
- `score`: 相似度分数（0-1之间，越大越相似）

**特点**
- 🐍 **易调试**: Python实现，便于开发和调试
- 🎯 **功能丰富**: 支持时间衰减、日期维度等高级特性
- 📊 **归一化**: 相似度分数已归一化到0-1区间
- 📁 **文件位置**: `offline_tasks/output/i2i_*_YYYYMMDD.txt`

#### 1.3 算法对比

| 算法 | 实现语言 | 性能 | 特点 | 适用场景 |
|------|---------|------|------|---------|
| **Swing (C++)** | C++ | ⚡⚡⚡ | 高性能，大规模数据 | 生产环境，海量数据 |
| **Swing (Python)** | Python | ⚡ | 支持日期维度，时间衰减 | 需要高级特性 |
| **Session W2V** | Python | ⚡ | 基于会话序列 | 详情页"看了又看" |
| **DeepWalk** | Python | ⚡ | 基于图结构 | 详情页"相关推荐" |
| **Content** | Python | ⚡⚡ | 基于商品属性 | 冷启动商品推荐 |

#### 1.4 使用建议

**C++ Swing适用场景**:
- 商品数量 > 50,000
- 需要快速计算结果
- 生产环境部署
- 计算资源有限

**Python Swing适用场景**:
- 需要时间衰减功能
- 需要日期维度分析
- 开发调试阶段
- 需要灵活调整参数

### 2. 兴趣点聚合索引

#### 输出格式
```
dimension_key \t item_id1,item_id2,item_id3,...
```

#### 示例
```
platform:pc	12345,67890,11223,44556,22334
category_level2:200	67890,12345,22334,55667,11223
platform_category2:pc_200	12345,67890,22334,11223,55667
supplier:10001	12345,44556,22334,67890,11223
```

#### 维度说明

**单维度（7个）**
- `platform:{platform_id}` - 业务平台（pc, h5, app等）
- `client_platform:{client}` - 客户端平台（iOS, Android, Web等）
- `supplier:{supplier_id}` - 供应商
- `category_level1:{cat_id}` - 一级分类
- `category_level2:{cat_id}` - 二级分类
- `category_level3:{cat_id}` - 三级分类
- `category_level4:{cat_id}` - 四级分类

**组合维度（4个）**
- `platform_client:{platform}_{client}` - 平台+客户端
- `platform_category2:{platform}_{cat_id}` - 平台+二级分类
- `platform_category3:{platform}_{cat_id}` - 平台+三级分类
- `client_category2:{client}_{cat_id}` - 客户端+二级分类

#### 列表类型说明

| 类型 | 文件名 | 计算逻辑 | 适用场景 |
|------|--------|---------|---------|
| **hot** | `interest_aggregation_hot_YYYYMMDD.txt` | 最近N天的高频交互商品 | 首页"热门推荐" |
| **cart** | `interest_aggregation_cart_YYYYMMDD.txt` | 高加购率商品 | 首页"热门加购" |
| **new** | `interest_aggregation_new_YYYYMMDD.txt` | 最近上架的新品 | 首页"新品推荐" |
| **global** | `interest_aggregation_global_YYYYMMDD.txt` | 全局热门商品 | 首页"猜你喜欢" |

## 🔄 调度建议

### 每日调度（数据量大，变化快）
```bash
# 每天凌晨3点执行
0 3 * * * cd /home/tw/recommendation/offline_tasks && python3 run_all.py --lookback_days 730 --top_n 50
```

### 每周调度（数据量小，变化慢）
```bash
# 每周日凌晨4点执行
0 4 * * 0 cd /home/tw/recommendation/offline_tasks && python3 scripts/i2i_content_similar.py --top_n 50
```

## 📁 文件命名规范

### 标准格式
```
{algorithm_name}_{date}.txt
```

### 示例
```
i2i_swing_20251016.txt
i2i_session_w2v_20251016.txt
interest_aggregation_hot_20251016.txt
```

### Debug文件（开发调试用）
```
output/debug/{algorithm_name}_{date}_readable.txt
logs/debug/{algorithm_name}_{date}_{time}.log
```

## 📈 数据量估算

| 索引类型 | 索引数量 | 单条大小 | 总大小 | 更新频率 |
|---------|---------|---------|--------|---------|
| i2i_swing_cpp | ~50,000 | ~400B | ~20MB | 每天 |
| i2i_swing | ~50,000 | ~500B | ~25MB | 每天 |
| i2i_session_w2v | ~50,000 | ~500B | ~25MB | 每天 |
| i2i_deepwalk | ~50,000 | ~500B | ~25MB | 每天 |
| i2i_content | ~50,000 | ~500B | ~25MB | 每周 |
| interest_hot | ~10,000 | ~1KB | ~10MB | 每天 |
| interest_cart | ~10,000 | ~1KB | ~10MB | 每天 |
| interest_new | ~5,000 | ~1KB | ~5MB | 每天 |
| interest_global | ~10,000 | ~1KB | ~10MB | 每天 |
| **总计** | **~295,000** | - | **~155MB** | - |

**说明**:
- C++ Swing因为不包含商品名称，单条大小较小
- 推荐同时使用C++ Swing（生产）和Python Swing（开发）

## 🎯 质量检查

### 数据完整性检查
```bash
# 检查文件是否生成
ls -lh output/*_$(date +%Y%m%d).txt

# 检查行数
wc -l output/*_$(date +%Y%m%d).txt

# 检查格式
head -5 output/i2i_swing_$(date +%Y%m%d).txt
```

### 数据质量指标

**i2i索引质量**
- 覆盖率：有推荐的商品数 / 总商品数 > 80%
- 推荐数量：每个商品推荐10-50个相似商品
- 分数范围：相似度分数在0.01-1.0之间

**兴趣聚合质量**
- 覆盖率：有数据的维度数 / 总维度数 > 60%
- 推荐数量：每个维度推荐50-1000个商品
- 商品去重：同一商品在列表中只出现一次

## 🔍 查询示例

### 查看特定商品的相似推荐
```bash
# 查看商品12345的相似商品
grep "^12345\t" output/i2i_swing_20251016.txt
```

### 查看特定维度的热门商品
```bash
# 查看PC平台的热门商品
grep "^platform:pc\t" output/interest_aggregation_hot_20251016.txt
```

### 统计索引数量
```bash
# 统计各类型索引数量
for file in output/*_20251016.txt; do
    echo "$file: $(wc -l < $file) 条"
done
```

## ⚠️ 注意事项

1. **文件编码**: 所有文件使用UTF-8编码
2. **分隔符**: 使用Tab（\t）分隔字段
3. **商品ID**: 使用数字类型，不带引号
4. **分数精度**: 相似度分数保留4位小数
5. **排序规则**: 相似商品按分数降序排列
6. **去重**: 确保推荐列表中没有重复商品
7. **有效性**: 推荐的商品必须是在售状态

## 🔗 相关文档

- **Redis数据规范**: `REDIS_DATA_SPEC.md`
- **API接口文档**: `RECOMMENDATION_API.md`
- **Debug指南**: `DEBUG_GUIDE.md`
- **配置说明**: `UPDATE_CONFIG_GUIDE.md`
