# 推荐系统离线任务文档中心

本目录包含推荐系统离线任务的核心文档。

---

## 📚 核心文档

### 1. 详细设计文档

**文件**: [详细设计文档.md](./详细设计文档.md)

**内容**:
- 项目概述和系统架构
- 功能模块详解（i2i相似度、兴趣聚合）
- 使用指南和参数配置
- 业务场景应用示例
- 故障排查和性能优化

**适用对象**: 开发人员、产品经理、新人入门

---

### 2. 离线索引数据规范

**文件**: [离线索引数据规范.md](./离线索引数据规范.md)

**内容**:
- 索引任务列表和调度频次
- 输出文件格式详细说明
- i2i索引规范（C++ Swing、Python Swing、W2V、DeepWalk、Content）
- 兴趣聚合索引规范（维度、列表类型）
- 文件命名规范和数据质量检查

**适用对象**: 开发人员、数据工程师、运维人员

---

### 3. Redis数据规范

**文件**: [Redis数据规范.md](./Redis数据规范.md)

**内容**:
- Redis Key命名规范
- 数据灌入规范表
- i2i索引和兴趣聚合索引的存储格式
- 数据加载流程和示例代码
- 查询示例和监控指标

**适用对象**: 后端开发人员、运维人员

---

## 🎯 快速导航

### 我是新用户
1. 先阅读 **[详细设计文档.md](./详细设计文档.md)** 了解整体架构
2. 参考文档中的"快速开始"部分运行系统
3. 遇到问题查看"故障排查"章节

### 我是开发人员
1. 查看 **[详细设计文档.md](./详细设计文档.md)** 的"功能模块详解"
2. 参考 **[离线索引数据规范.md](./离线索引数据规范.md)** 了解数据格式
3. 开发在线接口时参考 **[Redis数据规范.md](./Redis数据规范.md)**

### 我是运维人员
1. 查看 **[详细设计文档.md](./详细设计文档.md)** 的"定时任务设置"
2. 参考 **[Redis数据规范.md](./Redis数据规范.md)** 进行数据加载
3. 遇到问题查看"故障排查"和日志文件

---

## 📂 其他资源

### 配置文件
- **离线任务配置**: `../config/offline_config.py`
- **主执行脚本**: `../run.sh`

### 相关模块文档
- **Collaboration模块** (C++ Swing): `../collaboration/README.md`
- **GraphEmbedding模块**: `../graphembedding/*/README.md`
- **Hot模块**: `../hot/README.md`

### 项目README
- **项目总览**: `../../README.md`
- **离线任务模块**: `../README.md`

---

## 🔄 文档更新记录

- **2024-10-17**: 整合文档，简化为3个核心文档
- **2024-10-16**: 初始版本，包含完整功能文档

---

## 📝 文档维护

所有文档由推荐系统团队维护。

如有疑问、发现错误或建议改进，请联系团队。

**最后更新**: 2024-10-17
