"""
离线任务配置文件
包含数据库连接、路径、参数等配置
"""
import os
from datetime import datetime, timedelta

# 数据库配置
DB_CONFIG = {
    'host': 'selectdb-cn-wuf3vsokg05-public.selectdbfe.rds.aliyuncs.com',
    'port': '9030',
    'database': 'datacenter',
    'username': 'readonly',
    'password': 'essa1234'
}

# 路径配置
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
OUTPUT_DIR = os.path.join(BASE_DIR, 'output')
LOG_DIR = os.path.join(BASE_DIR, 'logs')

# 确保目录存在
os.makedirs(OUTPUT_DIR, exist_ok=True)
os.makedirs(LOG_DIR, exist_ok=True)

# ============================================================================
# 默认参数配置（用于调试和生产）
# ============================================================================

# 时间配置（建议先用小数值调试，确认无误后再改为大数值）
DEFAULT_LOOKBACK_DAYS = 400    # 默认回看天数（调试用30天，生产可改为730天）
DEFAULT_RECENT_DAYS = 180       # 默认最近天数（调试用7天，生产可改为180天）

# i2i算法默认参数
DEFAULT_I2I_TOP_N = 50        # 默认返回Top N个相似商品

# 兴趣聚合默认参数
DEFAULT_INTEREST_TOP_N = 1000  # 默认每个key返回Top N个商品

# 获取时间范围
def get_time_range(days=DEFAULT_LOOKBACK_DAYS):
    """获取时间范围"""
    end_date = datetime.now()
    start_date = end_date - timedelta(days=days)
    return start_date.strftime('%Y-%m-%d'), end_date.strftime('%Y-%m-%d')

# i2i 行为相似算法配置
I2I_CONFIG = {
    # Swing 算法配置
    'swing': {
        'alpha': 0.5,           # swing算法的alpha参数
        'threshold1': 0.5,      # 交互强度阈值1
        'threshold2': 0.5,      # 交互强度阈值2
        'max_sim_list_len': 300,  # 最大相似列表长度
        'top_n': 50,            # 输出top N个相似商品
        'thread_num': 10,       # 线程数（如果使用C++版本）
    },
    
    # Session W2V 配置
    'session_w2v': {
        'max_sentence_length': 100,  # 最大句子长度
        'window_size': 5,            # 窗口大小
        'vector_size': 128,          # 向量维度
        'min_count': 2,              # 最小词频
        'workers': 10,               # 训练线程数
        'epochs': 10,                # 训练轮数
        'sg': 1,                     # 使用skip-gram
    },
    
    # DeepWalk 配置
    'deepwalk': {
        'num_walks': 10,         # 每个节点的游走次数
        'walk_length': 40,       # 游走长度
        'window_size': 5,        # 窗口大小
        'vector_size': 128,      # 向量维度
        'min_count': 2,          # 最小词频
        'workers': 10,           # 训练线程数
        'epochs': 10,            # 训练轮数
        'sg': 1,                 # 使用skip-gram
        'use_softmax': True,     # 使用softmax
        'temperature': 1.0,      # softmax温度
        'p_tag_walk': 0.2,       # 通过标签游走的概率
    }
}

# 兴趣点聚合配置
INTEREST_AGGREGATION_CONFIG = {
    'top_n': 1000,              # 每个key生成前N个商品
    'time_decay_factor': 0.95,  # 时间衰减因子（每30天）
    'min_interaction_count': 2,  # 最小交互次数
    
    # 行为权重
    'behavior_weights': {
        'click': 1.0,
        'addToCart': 3.0,
        'addToPool': 2.0,
        'contactFactory': 5.0,
        'purchase': 10.0,
    },
    
    # 类型配置
    'list_types': ['hot', 'cart', 'new'],  # 热门、加购、新品
}

# Redis配置（用于存储索引）
REDIS_CONFIG = {
    'host': 'localhost',
    'port': 6479,  # 统一使用6479端口
    'db': 0,
    'password': 'BMfv5aI31kgHWtlx',  # 6479端口需要认证
    'decode_responses': False
}

# 日志配置
LOG_CONFIG = {
    'level': 'INFO',
    'format': '%(asctime)s - %(name)s - %(levelname)s - %(message)s',
    'date_format': '%Y-%m-%d %H:%M:%S'
}

# Debug配置
DEBUG_CONFIG = {
    'enabled': False,           # 是否开启debug模式
    'log_level': 'DEBUG',       # debug日志级别
    'sample_size': 5,           # 数据采样大小
    'save_readable': True,      # 是否保存可读明文文件
    'log_dataframe_info': True, # 是否记录DataFrame详细信息
    'log_intermediate': True,   # 是否记录中间结果
}

