# Swing算法快速开始

## 快速运行（3步）

### 1. 生成Session文件

```bash
cd /home/tw/recommendation/offline_tasks
python3 scripts/generate_session.py --lookback_days 730
```

这会生成：
- `output/session.txt.YYYYMMDD` - 标准格式（uid \t json）
- `output/session.txt.YYYYMMDD.cpp` - C++格式（纯json）

### 2. 运行Swing算法

```bash
cd /home/tw/recommendation/collaboration
bash run.sh
```

### 3. 查看结果

```bash
# 查看可读版本（带商品名称）
cat output/swing_similar_readable.txt | head -20

# 或查看原始版本（仅ID）
cat output/swing_similar.txt | head -20
```

## 输出文件

- `output_YYYYMMDD/swing_similar.txt` - Swing相似度结果（ID格式）
- `output_YYYYMMDD/swing_similar_readable.txt` - 可读版本（ID:名称格式）

## 配置修改

如需调整参数，编辑 `run.sh`：

```bash
# 数据路径
SESSION_DATA_DIR="../offline_tasks/output"

# Swing参数
ALPHA=0.7          # 0.5-1.0，越小越关注用户共同行为
THRESHOLD1=1       # 1-5，交互强度阈值
THRESHOLD2=3       # 1-10，相似度计算阈值
THREAD_NUM=4       # 线程数
```

## 详细文档

查看完整文档：`../offline_tasks/SWING_USAGE.md`

## 常见问题

**Q: 如何查看商品名称？**
A: 结果文件 `swing_similar_readable.txt` 已自动添加商品名称

**Q: 如何调整相似商品数量？**
A: 修改 `src/swing.cc` 中的 `max_sim_list_len`（默认300）

**Q: Session文件找不到？**
A: 先运行步骤1生成session文件

**Q: 运行时间？**
A: 1万商品约1-5分钟，10万商品约10-30分钟

