"""
检查数据库表结构
用于确认字段名称
"""
import sys
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from db_service import create_db_connection
from offline_tasks.config.offline_config import DB_CONFIG
import pandas as pd

# 创建数据库连接
print("连接数据库...")
engine = create_db_connection(
    DB_CONFIG['host'],
    DB_CONFIG['port'],
    DB_CONFIG['database'],
    DB_CONFIG['username'],
    DB_CONFIG['password']
)

print("\n" + "="*80)
print("检查 prd_goods_sku 表结构")
print("="*80)

# 查看表结构
try:
    df = pd.read_sql("DESCRIBE prd_goods_sku", engine)
    print("\n表字段列表：")
    print(df.to_string())
except Exception as e:
    print(f"无法获取表结构: {e}")
    print("\n尝试查询前5条记录来推断结构...")
    try:
        df = pd.read_sql("SELECT * FROM prd_goods_sku LIMIT 5", engine)
        print("\n列名列表：")
        for col in df.columns:
            print(f"  - {col}")
    except Exception as e2:
        print(f"查询失败: {e2}")

print("\n" + "="*80)
print("检查 sensors_events 表结构")
print("="*80)

try:
    df = pd.read_sql("DESCRIBE sensors_events", engine)
    print("\n表字段列表：")
    print(df.to_string())
except Exception as e:
    print(f"无法获取表结构: {e}")
    print("\n尝试查询前5条记录来推断结构...")
    try:
        df = pd.read_sql("SELECT * FROM sensors_events LIMIT 5", engine)
        print("\n列名列表：")
        for col in df.columns:
            print(f"  - {col}")
    except Exception as e2:
        print(f"查询失败: {e2}")

print("\n" + "="*80)
print("检查完成")
print("="*80)

