# 推荐系统离线任务

推荐系统的离线索引生成模块，包含多种算法和数据处理任务。

## 🚀 快速开始

### 运行所有任务

```bash
cd /home/tw/recommendation/offline_tasks

# ⭐ 推荐：使用 run.sh（完整流程，包含Redis加载）
bash run.sh

# 备用：使用 run_all.py（简化版，不含C++ Swing和Redis）
python3 run_all.py --debug
```

**说明**:
- `run.sh`: 主执行脚本，包含完整流程、内存监控、自动Redis加载
- `run_all.py`: Python简化版本，只包含Python算法任务

### 任务执行顺序

```
前置任务:
1. fetch_item_attributes.py     → 获取商品属性映射
2. generate_session.py          → 生成用户行为session
3. collaboration/run.sh         → C++ Swing算法（高性能）

核心算法任务:
4. i2i_swing.py                → Python Swing（支持日期维度）
5. i2i_session_w2v.py          → Session W2V
6. i2i_deepwalk.py             → DeepWalk
7. i2i_content_similar.py      → 内容相似度
8. interest_aggregation.py     → 兴趣聚合
```

## 📚 文档

所有文档位于 **`doc/`** 目录：

- **[doc/快速开始.md](./doc/快速开始.md)** - 新手入门
- **[doc/Swing算法使用指南.md](./doc/Swing算法使用指南.md)** - 详细使用
- **[doc/系统改进总结-20241017.md](./doc/系统改进总结-20241017.md)** - 最新改进
- **[doc/README.md](./doc/README.md)** - 完整文档索引

## 🔧 核心功能

### 1. 前置任务优化

- **商品属性缓存**: 一次获取，多次使用，减少90%数据库查询
- **Session文件复用**: 统一生成，多算法共享
- **C++ Swing集成**: 自动执行，高性能计算

### 2. 算法增强

- **双维度Swing**: 同时考虑用户整体行为和单日行为
- **时间衰减**: 可选的时间权重衰减
- **Debug模式**: 自动生成可读版本（ID + 名称）

### 3. 自动化流程

```bash
# 一条命令完成所有任务
python3 run_all.py --debug
```

输出文件：
- `output/item_attributes_mappings.json` - ID映射
- `output/session.txt.YYYYMMDD` - 用户session
- `collaboration/output/swing_similar.txt` - C++ Swing结果
- `output/i2i_swing_YYYYMMDD.txt` - Python Swing结果
- ... 其他算法输出

## 📊 性能对比

| 任务 | 改进前 | 改进后 | 提升 |
|------|--------|--------|------|
| 数据库查询 | 5-10次 | 1次 | 80-90% ↓ |
| Swing性能 | Python | C++ | 10-100x ↑ |
| 任务管理 | 手动分步 | 自动流程 | 100% ↑ |

## 🛠️ 单独运行任务

### 1. 获取商品属性

```bash
python3 scripts/fetch_item_attributes.py
```

### 2. 生成Session

```bash
python3 scripts/generate_session.py --lookback_days 730
```

### 3. C++ Swing

```bash
cd collaboration
bash run.sh
```

### 4. Python Swing（支持日期维度）

```bash
python3 scripts/i2i_swing.py --lookback_days 730 --use_daily_session --debug
```

### 5. 其他算法

```bash
# Session W2V
python3 scripts/i2i_session_w2v.py --lookback_days 730 --debug

# DeepWalk
python3 scripts/i2i_deepwalk.py --lookback_days 730 --debug

# 内容相似度
python3 scripts/i2i_content_similar.py

# 兴趣聚合
python3 scripts/interest_aggregation.py --lookback_days 730 --debug
```

## 📁 项目结构

```
offline_tasks/
├── scripts/              # 所有任务脚本
│   ├── fetch_item_attributes.py
│   ├── generate_session.py
│   ├── i2i_swing.py
│   ├── i2i_session_w2v.py
│   ├── i2i_deepwalk.py
│   ├── i2i_content_similar.py
│   ├── interest_aggregation.py
│   ├── add_names_to_swing.py
│   └── debug_utils.py
├── collaboration/        # C++ Swing算法
│   ├── src/
│   ├── bin/
│   ├── run.sh
│   └── output/
├── config/               # 配置文件
│   └── offline_config.py
├── doc/                  # 文档中心
│   ├── README.md
│   ├── 快速开始.md
│   ├── Swing算法使用指南.md
│   └── ...
├── output/               # 输出目录
│   ├── item_attributes_mappings.json
│   ├── session.txt.*
│   └── *.txt
├── logs/                 # 日志目录
├── run.sh               # 主执行脚本（推荐）
├── run_all.py           # Python版本（简化）
└── README.md            # 本文件
```

## ⚙️ 配置

配置文件：`config/offline_config.py`

主要参数：
```python
DEFAULT_LOOKBACK_DAYS = 730    # 数据回看天数
DEFAULT_I2I_TOP_N = 50         # i2i推荐数量
DEFAULT_INTEREST_TOP_N = 1000  # 兴趣聚合数量

# 数据库配置
DB_CONFIG = {...}

# 算法参数
I2I_CONFIG = {...}
```

## 🐛 故障排查

### 常见问题

**1. 映射文件不存在**
```bash
# 先运行前置任务
python3 scripts/fetch_item_attributes.py
```

**2. Session文件找不到**
```bash
# 生成session文件
python3 scripts/generate_session.py
```

**3. C++ Swing编译失败**
```bash
cd collaboration
make clean
make
```

详见：[doc/故障排查指南.md](./doc/故障排查指南.md)

## 📝 日志

日志位置：
- 主日志：`logs/run_all_YYYYMMDD.log`
- Debug日志：`logs/debug/*.log`

查看最新日志：
```bash
tail -f logs/run_all_$(date +%Y%m%d).log
```

## 🔗 相关项目

- **Collaboration**: `../collaboration/` - C++ 协同过滤
- **GraphEmbedding**: `../graphembedding/` - 图embedding
- **Hot**: `../hot/` - 热门推荐
- **Frontend**: `../frontend/` - 推荐接口

## 📞 更多信息

- **完整文档**: [doc/README.md](./doc/README.md)
- **改进总结**: [doc/系统改进总结-20241017.md](./doc/系统改进总结-20241017.md)
- **故障排查**: [doc/故障排查指南.md](./doc/故障排查指南.md)

---

**最后更新**: 2024-10-17  
**状态**: ✅ 生产就绪
