#!/bin/bash

# 清理老数据
find . -type d -name 'output.bak.*' -ctime +180 -exec rm -rf {} \;
find logs/ -type f -mtime +180 -exec rm -f {} \;

if [ -d "output" ]; then
  # 获取当前时间戳，格式为年-月-日_时-分-秒
  timestamp=$(date +%Y-%m-%d_%H-%M-%S)
  # 重命名目录
  mv output "output.bak.${timestamp}"
fi


mkdir -p output


# 准备数据
python3 prepare_data.py ../../fetch_data/data/session.txt.all output/session.txt.all 100

# 输出 bid_top_similar.txt 和 bid_embeddings.txt
# epochs为5的适合，embedding非常集中，top200的相似书籍相似度都在0.99以上，调到10 top1~top200相似度大概为0.9~0.8，20的时候，top1~top200相似度大概在0.75~0.6
python3 w2v.py  --input-file output/session.txt.all --output-dir output/ --epochs 20

