#!/bin/bash


# 清理老数据
find . -type d -name 'output.bak.*' -ctime +180 -exec rm -rf {} \;
find logs/ -type f -mtime +180 -exec rm -f {} \;

if [ -d "output" ]; then
  # 获取当前时间戳，格式为年-月-日_时-分-秒
  timestamp=$(date +%Y-%m-%d_%H-%M-%S)
  # 重命名目录
  mv output "output.bak.${timestamp}"
fi

mkdir -p output


# 定义参数
EDGE_FILE="../../fetch_data/data/edge.txt.all"       # 边文件的路径
# EDGE_FILE="../../fetch_data/data/edge.txt.20240226"       # 边文件的路径
NUM_WALKS=100                                        # 每个节点的随机游走次数
WALK_LENGTH=40                                       # 每次游走的长度
WORKERS=$(($(nproc) - 2))                            # 并行工作的线程数,cpu个数-2
WORKERS=$((WORKERS < 40 ? WORKERS : 40))             # 
USE_SOFTMAX="--use-softmax"                          # 是否使用softmax
TEMPERATURE=1.0                                      # softmax的温度参数
OUTPUT_FILE="output/walks.txt"                       # 输出文件

# 运行DeepWalk程序
python deepwalk.py --edge-file $EDGE_FILE \
                   --num-walks $NUM_WALKS \
                   --walk-length $WALK_LENGTH \
                   --workers $WORKERS \
                   $USE_SOFTMAX \
                   --temperature $TEMPERATURE \
                   --output-file $OUTPUT_FILE \
                   --node-tag-file ../../tags/output/filtered_books.tags
                   
# 输出 bid_top_similar.txt 和 bid_embeddings.txt
python w2v.py  --input-file output/walks.txt --output-dir output/ --workers $WORKERS

