#!/bin/bash

# Test Frontend - Quick verification script

set -e

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

API_URL="http://120.76.41.98:6002"

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}Frontend Test Script${NC}"
echo -e "${GREEN}========================================${NC}"

echo -e "\n${YELLOW}Testing API endpoints...${NC}"

# Test 1: Health check
echo -e "\n1. Testing health endpoint..."
if curl -s "${API_URL}/health" > /dev/null; then
    echo -e "${GREEN}✓ Health check passed${NC}"
else
    echo -e "${RED}✗ Health check failed${NC}"
    exit 1
fi

# Test 2: Frontend HTML
echo -e "\n2. Testing frontend HTML..."
if curl -s "${API_URL}/" | grep -q "Product Search"; then
    echo -e "${GREEN}✓ Frontend HTML accessible${NC}"
else
    echo -e "${RED}✗ Frontend HTML not found${NC}"
    exit 1
fi

# Test 3: Static CSS
echo -e "\n3. Testing static CSS..."
if curl -s "${API_URL}/static/css/style.css" | grep -q "page-container"; then
    echo -e "${GREEN}✓ CSS file accessible${NC}"
else
    echo -e "${RED}✗ CSS file not found${NC}"
    exit 1
fi

# Test 4: Static JS
echo -e "\n4. Testing static JavaScript..."
if curl -s "${API_URL}/static/js/app.js" | grep -q "performSearch"; then
    echo -e "${GREEN}✓ JavaScript file accessible${NC}"
else
    echo -e "${RED}✗ JavaScript file not found${NC}"
    exit 1
fi

# Test 5: Search API
echo -e "\n5. Testing search API..."
SEARCH_RESULT=$(curl -s -X POST "${API_URL}/search/" \
    -H "Content-Type: application/json" \
    -d '{"query":"玩具","size":5}')

if echo "$SEARCH_RESULT" | grep -q "hits"; then
    echo -e "${GREEN}✓ Search API working${NC}"
    TOTAL=$(echo "$SEARCH_RESULT" | grep -o '"total":[0-9]*' | cut -d: -f2)
    echo -e "  Found ${YELLOW}${TOTAL}${NC} results"
else
    echo -e "${RED}✗ Search API failed${NC}"
    exit 1
fi

echo -e "\n${GREEN}========================================${NC}"
echo -e "${GREEN}All tests passed! ✓${NC}"
echo -e "${GREEN}========================================${NC}"

echo -e "\n${YELLOW}Frontend is ready!${NC}"
echo -e "Open in browser: ${GREEN}${API_URL}/${NC}"

echo -e "\n${YELLOW}Quick Start Guide:${NC}"
echo "1. Open browser and go to: ${API_URL}/"
echo "2. Enter a search query (e.g., '玩具')"
echo "3. Click on filter tags to refine results"
echo "4. Use sort buttons with arrows to sort"
echo "5. Use pagination at the bottom to browse"

echo -e "\n${YELLOW}Key Features:${NC}"
echo "- Clean white background design"
echo "- Horizontal filter tags (categories, brands, suppliers)"
echo "- Sort buttons with up/down arrows for ascending/descending"
echo "- Product grid with images, prices, MOQ info"
echo "- Full pagination support"
echo "- Responsive design for mobile and desktop"

echo -e "\n${GREEN}Enjoy your new frontend! 🎉${NC}"

