#!/bin/bash

# 停止测试环境脚本

set -e

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 配置
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_ROOT="$(dirname "$SCRIPT_DIR")"
PID_FILE="$PROJECT_ROOT/test_environment.pid"
ES_PID_FILE="$PROJECT_ROOT/test_logs/es.pid"

echo -e "${BLUE}========================================${NC}"
echo -e "${BLUE}停止测试环境${NC}"
echo -e "${BLUE}========================================${NC}"

# 停止API服务
if [ -f "$PID_FILE" ]; then
    API_PID=$(cat "$PID_FILE")
    if ps -p $API_PID > /dev/null 2>&1; then
        echo -e "${BLUE}停止API服务 (PID: $API_PID)...${NC}"
        kill $API_PID

        # 等待进程结束
        for i in {1..10}; do
            if ! ps -p $API_PID > /dev/null 2>&1; then
                echo -e "${GREEN}✓ API服务已停止${NC}"
                break
            fi
            if [ $i -eq 10 ]; then
                echo -e "${YELLOW}强制停止API服务...${NC}"
                kill -9 $API_PID 2>/dev/null || true
            fi
            sleep 1
        done
    else
        echo -e "${YELLOW}API服务进程不存在${NC}"
    fi
    rm -f "$PID_FILE"
else
    echo -e "${YELLOW}未找到API服务PID文件${NC}"
fi

# 停止Elasticsearch（如果是本地启动的）
if [ -f "$ES_PID_FILE" ]; then
    ES_PID=$(cat "$ES_PID_FILE")
    if ps -p $ES_PID > /dev/null 2>&1; then
        echo -e "${BLUE}停止本地Elasticsearch (PID: $ES_PID)...${NC}"
        kill $ES_PID
        rm -f "$ES_PID_FILE"
        echo -e "${GREEN}✓ Elasticsearch已停止${NC}"
    else
        echo -e "${YELLOW}Elasticsearch进程不存在${NC}"
        rm -f "$ES_PID_FILE"
    fi
else
    echo -e "${BLUE}跳过本地Elasticsearch停止（未找到PID文件）${NC}"
fi

# 清理测试环境文件
echo -e "${BLUE}清理测试环境文件...${NC}"
rm -f "$PROJECT_ROOT/test_env.sh"

# 清理测试索引（可选）
read -p "是否删除测试索引? (y/N): " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo -e "${BLUE}删除测试索引...${NC}"
    curl -X DELETE "http://localhost:9200/test_products" 2>/dev/null || true
    echo -e "${GREEN}✓ 测试索引已删除${NC}"
fi

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}测试环境已停止！${NC}"
echo -e "${GREEN}========================================${NC}"