#!/bin/bash

# Stop script for Search Engine services
# This script stops both backend and frontend servers

echo "========================================"
echo "Stopping Search Engine Services"
echo "========================================"

# Kill processes on port 6002 (backend)
BACKEND_PIDS=$(lsof -ti:6002 2>/dev/null)
if [ ! -z "$BACKEND_PIDS" ]; then
    echo "Stopping backend server(s) on port 6002..."
    for PID in $BACKEND_PIDS; do
        echo "  Killing PID: $PID"
        kill -TERM $PID 2>/dev/null || true
    done
    sleep 2
    # Force kill if still running
    REMAINING_PIDS=$(lsof -ti:6002 2>/dev/null)
    if [ ! -z "$REMAINING_PIDS" ]; then
        echo "  Force killing remaining processes..."
        for PID in $REMAINING_PIDS; do
            kill -KILL $PID 2>/dev/null || true
        done
    fi
    echo "Backend server stopped."
else
    echo "No backend server found running on port 6002."
fi

# Kill processes on port 6003 (frontend)
FRONTEND_PIDS=$(lsof -ti:6003 2>/dev/null)
if [ ! -z "$FRONTEND_PIDS" ]; then
    echo "Stopping frontend server(s) on port 6003..."
    for PID in $FRONTEND_PIDS; do
        echo "  Killing PID: $PID"
        kill -TERM $PID 2>/dev/null || true
    done
    sleep 2
    # Force kill if still running
    REMAINING_PIDS=$(lsof -ti:6003 2>/dev/null)
    if [ ! -z "$REMAINING_PIDS" ]; then
        echo "  Force killing remaining processes..."
        for PID in $REMAINING_PIDS; do
            kill -KILL $PID 2>/dev/null || true
        done
    fi
    echo "Frontend server stopped."
else
    echo "No frontend server found running on port 6003."
fi

# Also stop any processes using PID files
if [ -f "logs/backend.pid" ]; then
    BACKEND_PID=$(cat logs/backend.pid 2>/dev/null)
    if [ ! -z "$BACKEND_PID" ] && kill -0 $BACKEND_PID 2>/dev/null; then
        echo "Stopping backend server via PID file (PID: $BACKEND_PID)..."
        kill -TERM $BACKEND_PID 2>/dev/null || true
        sleep 2
        kill -KILL $BACKEND_PID 2>/dev/null || true
    fi
    rm -f logs/backend.pid
fi

if [ -f "logs/frontend.pid" ]; then
    FRONTEND_PID=$(cat logs/frontend.pid 2>/dev/null)
    if [ ! -z "$FRONTEND_PID" ] && kill -0 $FRONTEND_PID 2>/dev/null; then
        echo "Stopping frontend server via PID file (PID: $FRONTEND_PID)..."
        kill -TERM $FRONTEND_PID 2>/dev/null || true
        sleep 2
        kill -KILL $FRONTEND_PID 2>/dev/null || true
    fi
    rm -f logs/frontend.pid
fi

echo "========================================"
echo "All services stopped successfully!"
echo "========================================"