#!/bin/bash

# Start Frontend Server

set -e

cd "$(dirname "$0")/.."
source /home/tw/miniconda3/etc/profile.d/conda.sh
conda activate searchengine

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}Starting Frontend Server${NC}"
echo -e "${GREEN}========================================${NC}"

PORT=6003

echo -e "\n${YELLOW}Frontend will be available at:${NC}"
echo -e "  ${GREEN}http://localhost:$PORT${NC}"
echo ""
echo -e "${YELLOW}Make sure the backend API is running at:${NC}"
echo -e "  ${GREEN}http://localhost:6002${NC}"
echo ""

python scripts/frontend_server.py
