#!/bin/bash

# Start Backend API Service

set -e

cd "$(dirname "$0")/.."
source /home/tw/miniconda3/etc/profile.d/conda.sh
conda activate searchengine

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}Starting Backend API Service${NC}"
echo -e "${GREEN}========================================${NC}"

# Load config from .env file if it exists
if [ -f .env ]; then
    set -a
    source .env
    set +a
fi

echo -e "\n${YELLOW}Configuration:${NC}"
echo "  API Host: ${API_HOST:-0.0.0.0}"
echo "  API Port: ${API_PORT:-6002}"
echo "  ES Host: ${ES_HOST:-http://localhost:9200}"
echo "  ES Username: ${ES_USERNAME:-not set}"

echo -e "\n${YELLOW}Starting service (multi-tenant)...${NC}"

# Export environment variables for the Python process
export API_HOST=${API_HOST:-0.0.0.0}
export API_PORT=${API_PORT:-6002}
export ES_HOST=${ES_HOST:-http://localhost:9200}
export ES_USERNAME=${ES_USERNAME:-}
export ES_PASSWORD=${ES_PASSWORD:-}

python -m api.app \
  --host $API_HOST \
  --port $API_PORT \
  --es-host $ES_HOST

