#!/bin/bash

# Unified startup script for SearchEngine services
# This script starts both frontend and backend services

cd "$(dirname "$0")/.."

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}SearchEngine服务启动脚本${NC}"
echo -e "${GREEN}========================================${NC}"

# Create logs directory if it doesn't exist
mkdir -p logs

# Step 1: Start backend in background
echo -e "\n${YELLOW}Step 1/2: 启动后端服务${NC}"
echo -e "${YELLOW}后端服务将在后台运行...${NC}"

nohup ./scripts/start_backend.sh > logs/backend.log 2>&1 &
BACKEND_PID=$!
echo $BACKEND_PID > logs/backend.pid
echo -e "${GREEN}后端服务已启动 (PID: $BACKEND_PID)${NC}"
echo -e "${GREEN}日志文件: logs/backend.log${NC}"

# Wait for backend to start
echo -e "${YELLOW}等待后端服务启动...${NC}"
MAX_RETRIES=30
RETRY_COUNT=0
BACKEND_READY=false

while [ $RETRY_COUNT -lt $MAX_RETRIES ]; do
    sleep 2
    if curl -s http://localhost:6002/health > /dev/null 2>&1; then
        BACKEND_READY=true
        break
    fi
    RETRY_COUNT=$((RETRY_COUNT + 1))
    echo -e "${YELLOW}  等待中... ($RETRY_COUNT/$MAX_RETRIES)${NC}"
done

# Check if backend is running
if [ "$BACKEND_READY" = true ]; then
    echo -e "${GREEN}✓ 后端服务运行正常${NC}"
else
    echo -e "${RED}✗ 后端服务启动失败，请检查日志: logs/backend.log${NC}"
    echo -e "${YELLOW}提示: 后端服务可能需要更多时间启动，或者检查端口是否被占用${NC}"
    exit 1
fi

# Step 2: Start frontend in background
echo -e "\n${YELLOW}Step 2/2: 启动前端服务${NC}"
echo -e "${YELLOW}前端服务将在后台运行...${NC}"

nohup ./scripts/start_frontend.sh > logs/frontend.log 2>&1 &
FRONTEND_PID=$!
echo $FRONTEND_PID > logs/frontend.pid
echo -e "${GREEN}前端服务已启动 (PID: $FRONTEND_PID)${NC}"
echo -e "${GREEN}日志文件: logs/frontend.log${NC}"

# Wait for frontend to start
echo -e "${YELLOW}等待前端服务启动...${NC}"
MAX_RETRIES=15
RETRY_COUNT=0
FRONTEND_READY=false

while [ $RETRY_COUNT -lt $MAX_RETRIES ]; do
    sleep 2
    if curl -s http://localhost:6003/ > /dev/null 2>&1; then
        FRONTEND_READY=true
        break
    fi
    RETRY_COUNT=$((RETRY_COUNT + 1))
    echo -e "${YELLOW}  等待中... ($RETRY_COUNT/$MAX_RETRIES)${NC}"
done

# Check if frontend is running
if [ "$FRONTEND_READY" = true ]; then
    echo -e "${GREEN}✓ 前端服务运行正常${NC}"
else
    echo -e "${YELLOW}⚠ 前端服务可能还在启动中，请稍后访问${NC}"
fi

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}所有服务启动完成!${NC}"
echo -e "${GREEN}========================================${NC}"
echo ""
echo -e "访问地址:"
echo -e "  ${GREEN}前端界面: http://localhost:6003${NC}"
echo -e "  ${GREEN}后端API: http://localhost:6002${NC}"
echo -e "  ${GREEN}API文档: http://localhost:6002/docs${NC}"
echo ""
echo -e "日志文件:"
echo -e "  后端: logs/backend.log"
echo -e "  前端: logs/frontend.log"
echo ""
echo -e "停止服务:"
echo -e "  所有服务: ./scripts/stop.sh"
echo -e "  单独停止后端: kill \$(cat logs/backend.pid)"
echo -e "  单独停止前端: kill \$(cat logs/frontend.pid)"
echo ""

