#!/bin/bash

# Restart script for SearchEngine services
# This script stops all services first, then starts them again

cd "$(dirname "$0")"

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

echo -e "${GREEN}========================================${NC}"
echo -e "${GREEN}SearchEngine服务重启脚本${NC}"
echo -e "${GREEN}========================================${NC}"

# Step 1: Stop all services
echo -e "\n${YELLOW}Step 1/2: 停止现有服务${NC}"
if [ -f "./scripts/stop.sh" ]; then
    ./scripts/stop.sh
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓ 所有服务已成功停止${NC}"
    else
        echo -e "${YELLOW}⚠ 停止服务时出现警告，继续重启流程${NC}"
    fi
else
    echo -e "${RED}✗ 停止脚本不存在，无法安全重启${NC}"
    exit 1
fi

# Wait a moment for services to fully stop
echo -e "\n${YELLOW}等待服务完全关闭...${NC}"
sleep 3

# Step 2: Start all services
echo -e "\n${YELLOW}Step 2/2: 重新启动服务${NC}"
if [ -f "./scripts/start.sh" ]; then
    ./scripts/start.sh
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}========================================${NC}"
        echo -e "${GREEN}服务重启完成!${NC}"
        echo -e "${GREEN}========================================${NC}"
    else
        echo -e "${RED}✗ 服务启动失败${NC}"
        exit 1
    fi
else
    echo -e "${RED}✗ 启动脚本不存在，无法完成重启${NC}"
    exit 1
fi