# ES Mapping Configuration

## 概述

所有租户共享同一个ES mapping结构，直接使用手写的JSON文件，无需通过config.yaml生成。

## Mapping文件

- `search_products.json`: 完整的ES索引配置，包括settings和mappings

## 使用方式

### 创建索引

```python
from indexer.mapping_generator import load_mapping, create_index_if_not_exists
from utils.es_client import ESClient

es_client = ESClient(hosts=["http://localhost:9200"])
mapping = load_mapping()  # 从mappings/search_products.json加载
create_index_if_not_exists(es_client, "search_products", mapping)
```

### 修改Mapping

直接编辑 `mappings/search_products.json` 文件，然后重新创建索引。

注意：ES不支持修改已有字段的mapping类型，只能添加新字段。如需修改字段类型，需要：
1. 删除旧索引
2. 使用新mapping创建索引
3. 重新导入数据

## 字段说明

参考 `docs/索引字段说明v2-mapping结构.md`

