# 索引重构v2方案

## 概述

根据 `索引字段说明v2.md` 的要求重构Elasticsearch索引映射结构和MySQL到ES的数据导入脚本。

## 主要变更点

### 1. 索引映射结构重构

#### 1.1 多语言文本字段

- 为文本字段添加中英文双字段支持（title_zh/title_en, brief_zh/brief_en, description_zh/description_en, vendor_zh/vendor_en）
- 中文字段使用 `index_ansj`/`query_ansj` 分析器（对应文档中的hanlp_index/hanlp_standard）
- 英文字段使用 `english` 分析器
- **暂时只填充中文字段，英文字段设为空**（不需要语言检测，每个tenant的语言预先知道）

#### 1.2 分类字段多层级支持

类别数据源：
在spu表中：
Field Type
category  varchar(255)
category_id bigint(20)
category_google_id  bigint(20)
category_level  int(11)
category_path varchar(500)

mapping：

      "category_path_zh": { // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "category_path_en": {  // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english"
      },
      "category_name_zh": { // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "category_name_en": {  // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english"
      },

      "category_id": {
        "type": "keyword"
      },
      "category_name": {
        "type": "keyword"
      },
      "category_level": {
        "type": "integer"
      },
      "category1_name": { // 不同层级下 可能有同名的情况，因此提供一二三级分开的查询方式
        "type": "keyword"
      },
      "category2_name": {
        "type": "keyword"
      },
      "category3_name": {
        "type": "keyword"
      },


#### 1.3 SKU字段展开

- 添加 `sku_prices` (float数组) - 所有SKU价格列表
- 添加 `sku_weights` (long数组) - 重量数值列表（转换为整数克）
- 添加 `sku_weight_units` (keyword数组) - 重量+单位字符串列表
- 添加 `total_inventory` (long) - SKU库存总和
- 保留 `min_price`, `max_price` (float)

#### 1.4 选项字段处理

- 添加 `option1_name`, `option2_name`, `option3_name` (keyword) - SPU级别的选项名称定义
- 修改SKU嵌套结构：将 `options` 对象改为 `option1_value`, `option2_value`, `option3_value` (keyword)
- 添加 `specifications` (nested, index=false) - 动态属性，仅用于返回

#### 1.5 标签字段

- `tags` 改为 keyword 数组类型（分割逗号分隔的字符串）

#### 1.6 SKU嵌套结构更新

- 添加 `sku_code` (keyword) 字段
- 添加 `weight` (float), `weight_unit` (keyword)
- 将 `options` 对象改为 `option1_value`, `option2_value`, `option3_value`
- 添加 `image_src` (keyword, index=false)

#### 1.7 删除SEO字段

- **完全删除** `seo_title`, `seo_description`, `seo_keywords` 字段
- 从索引映射中移除
- 从数据转换脚本中移除相关处理

### 2. 数据转换脚本重构

#### 2.1 多语言文本处理

- **简化处理**：暂时只填充中文字段（title_zh, brief_zh, description_zh, vendor_zh）
- 英文字段（title_en, brief_en, description_en, vendor_en）设为空或None
- 不需要语言检测逻辑

#### 2.2 分类路径解析

- 从 `category_path` 字段按 "/" 分割提取分类层级
- 分割结果赋值给 `category1_name`, `category2_name`, `category3_name`
- 生成 `category_path_zh`（暂时填充，`category_path_en` 设为空）

#### 2.3 SKU字段展开计算

- 提取所有SKU的价格，生成 `sku_prices` 数组
- 提取所有SKU的重量，转换为克（乘以1000），生成 `sku_weights` 数组
- 生成 `sku_weight_units` 数组（格式："重量值单位"）
- 计算所有SKU库存总和，赋值给 `total_inventory`
- 计算 `min_price` 和 `max_price`

#### 2.4 选项字段处理

- SPU级别的选项名称：需要从SPU数据或SKU数据推断（如果SPU表中没有，需要查看是否有选项表）
- SKU级别的选项值：从SKU的 `option1`, `option2`, `option3` 字段提取
- 生成 `specifications` 嵌套数组（从选项名称和值对生成）

#### 2.5 标签处理

- `tags` 字段按逗号分割转换为数组

#### 2.6 删除SEO字段处理

- **完全移除** seo_title, seo_description, seo_keywords 相关代码

## 实施步骤

### 步骤1：修改索引映射生成器

**文件**: `indexer/mapping_generator.py` 和相关字段配置

- 更新 `get_es_mapping_for_field` 函数以支持多语言字段
- 添加分类字段的完整映射生成逻辑
- 添加SKU展开字段的映射
- 添加选项字段的映射
- **删除SEO字段的映射生成**

### 步骤2：重构数据转换脚本

**文件**: `indexer/spu_transformer.py`

- **简化多语言处理**：只填充中文字段（title_zh, brief_zh等），英文字段设为空或None
- 实现分类路径的解析和展开
- 实现SKU字段的展开计算（价格、重量、库存）
- 实现选项字段的处理
- 更新SKU嵌套结构的生成
- 处理标签的分割
- **删除所有SEO字段相关代码**

### 步骤3：更新配置文件

**文件**: `config/config.yaml`

- **删除SEO字段配置**：移除 seo_title, seo_description, seo_keywords 的字段定义
- 可能需要添加新字段的配置定义，或者直接在代码中生成映射（如果配置系统不支持这些复杂字段）