{
  "mappings": {
    "properties": {
      "tenant_id": {
        "type": "keyword"
      },
      "spu_id": {
        "type": "keyword"
      },

      "create_time": {
        "type": "date"
      },
      "update_time": {
        "type": "date"
      },

      // 文本相关性相关字段
      "title_zh": {
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "brief_zh": {
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "description_zh": {
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "vendor_zh": {
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard",
        "fields": {
          "keyword": {
            "type": "keyword",
            "normalizer": "lowercase"
          }
        }
      },

      "title_en": {
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english",
      },
      "brief_en": {
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english",

      },
      "description_en": {
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english",
      },
      "vendor_en": {
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english",
        "fields": {
          "keyword": {
            "type": "keyword",
            "normalizer": "lowercase"
          }
        }
      },
      
      "tags": {
        "type": "keyword",
      },
      
      "image_url": {
        "type": "keyword",
        "index": false
      },
      
          // 语义向量
      "title_embedding": {
        "type": "dense_vector",
        "dims": 1024,
        "index": true,
        "similarity": "dot_product"
      },
      "image_embedding": {
        "type": "nested",
        "properties": {
          "vector": {
            "type": "dense_vector",
            "dims": 1024,
            "index": true,
            "similarity": "dot_product"
          },
          "url": {
            "type": "text"
          }
        }
      },

      // 分类相关
      "category_path_zh": { // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "category_path_en": {  // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english"
      },
      "category_name_zh": { // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "hanlp_index",
        "search_analyzer": "hanlp_standard"
      },
      "category_name_en": {  // 提供模糊查询功能，辅助相关性计算
        "type": "text",
        "analyzer": "english",
        "search_analyzer": "english"
      },

      "category_id": {
        "type": "keyword"
      },
      "category_name": {
        "type": "keyword"
      },
      "category_level": {
        "type": "integer"
      },
      "category1_name": { // 不同层级下 可能有同名的情况，因此提供一二三级分开的查询方式
        "type": "keyword"
      },
      "category2_name": {
        "type": "keyword"
      },
      "category3_name": {
        "type": "keyword"
      },

      // sku款式、子sku属性
      "specifications": {
        "type": "nested",
        "properties": {
          "sku_id":  { "type": "keyword" },  
          "name": { "type": "keyword" },         // "颜色", "容量"
          "value": { "type": "keyword" }         // "白色", "256GB"
        }
      },

      "option1_name": {
        "type": "keyword"
      },
      "option2_name": {
        "type": "keyword"
      },
      "option3_name": {
        "type": "keyword"
      },

      "min_price": {
        "type": "float"
      },
      "max_price": {
        "type": "float"
      },
      "compare_at_price": {
        "type": "float"
      },
      "sku_prices": {
        "type": "float"
      },
      "sku_weights": {
        "type": "long"
      },
      "sku_weight_units": {
        "type": "keyword"
      },
      "total_inventory": {
        "type": "long"
      },
      
      "skus": {
        "type": "nested",
        "properties": {
          "sku_id": {
            "type": "keyword"
          },
          "price": {
            "type": "float"
          },
          "compare_at_price": {
            "type": "float"
          },
          "sku_code": {
            "type": "keyword"
          },
          "stock": {
            "type": "long"
          },
          "weight": {
            "type": "float"
          },
          "weight_unit": {
            "type": "keyword"
          },
          "option1_value": {
            "type": "keyword"
          },
          "option2_value": {
            "type": "keyword"
          },
          "option3_value": {
            "type": "keyword"
          },
          "image_src": {
            "type": "keyword",
            "index": false
          }
        }
      }
    }
  }
}


