# Prefixbox Search API 完整文档

*基于公开信息整理的 Prefixbox Search API 技术文档*

*官方接口文档*
https://api-docs.prefixbox.com/#search-api


---

## 概述

Prefixbox Search API 是一个基于 AI 的电商搜索解决方案，提供全文搜索、向量搜索和混合搜索功能。该 API 支持自动完成、搜索建议、商品过滤、排序等核心电商搜索功能。

**核心特性：**
- 混合搜索（文本 + 向量 + GPT 技术）
- 自然语言查询理解
- 动态重排序
- 同义词管理
- 多语言支持

---

## 1. 基础信息

### 1.1 API 端点

```
基础 URL: https://api.prefixbox.com
版本: v1/v2 (根据集成方式不同)
```

### 1.2 认证方式

**API Key 认证**
- 在 Prefixbox API Portal 的 Profile 页面获取 Search API Key
- 所有请求必须在 Header 中包含：`Authorization: Bearer YOUR_SEARCH_API_KEY`
- 同时需要提供 Search Engine Identifier

**Header 示例：**
```http
Authorization: Bearer pb_live_abc123xyz...
X-Search-Engine-Id: your-engine-identifier
```

---

## 2. 核心 API 端点

### 2.1 自动完成 API (Autocomplete API)

**端点：** `GET /autocomplete`

**功能：** 当用户在搜索框输入时提供实时查询建议、分类建议和商品建议。

**请求参数：**

| 参数 | 类型 | 必填 | 说明 |
|------|------|------|------|
| `q` | string | 是 | 用户输入的查询字符串 |
| `limit` | integer | 否 | 返回建议的最大数量 (默认: 10) |
| `type` | string | 否 | 建议类型: `all`, `queries`, `categories`, `products` (默认: all) |
| `lang` | string | 否 | ISO 639-1 语言代码 (如: en, de, fr) |

**请求示例：**
```http
GET https://api.prefixbox.com/autocomplete?q=apple&limit=8&lang=en
Authorization: Bearer pb_live_abc123xyz...
X-Search-Engine-Id: your-engine-identifier
```

**响应格式：**
```json
{
  "query": "apple",
  "suggestions": {
    "queries": [
      {"text": "apple iphone", "count": 1250},
      {"text": "apple watch", "count": 890},
      {"text": "apple airpods", "count": 650}
    ],
    "categories": [
      {"id": "cat_001", "name": "Smartphones", "path": "Electronics/Mobile"},
      {"id": "cat_002", "name": "Accessories", "path": "Electronics/Accessories"}
    ],
    "products": [
      {
        "id": "prod_12345",
        "name": "Apple iPhone 15 Pro",
        "image": "https://cdn.example.com/iphone15.jpg",
        "price": 999.99,
        "currency": "USD",
        "url": "https://store.example.com/products/iphone-15-pro"
      }
    ]
  },
  "latency_ms": 45
}
```

---

### 2.2 搜索 API (Search API)

**端点：** `GET /search`

**功能：** 执行完整搜索并返回商品结果、过滤器、排序选项等。

**请求参数：**

| 参数 | 类型 | 必填 | 说明 |
|------|------|------|------|
| `q` | string | 是 | 搜索查询字符串 |
| `page` | integer | 否 | 页码 (默认: 1) |
| `page_size` | integer | 否 | 每页商品数量 (默认: 24, 最大: 100) |
| `sort` | string | 否 | 排序方式: `relevance`, `price_asc`, `price_desc`, `newest`, `popularity` |
| `filters` | object | 否 | 过滤器对象 `{"brand": ["Apple", "Samsung"], "price_range": {"min": 500, "max": 1000}}` |
| `lang` | string | 否 | 语言代码 |
| `user_id` | string | 否 | 用户ID（用于个性化）|
| `cdp_data` | object | 否 | 客户数据平台偏好数据 |

**请求示例：**
```http
GET https://api.prefixbox.com/search?q=running+shoes&page=1&page_size=24&sort=relevance
Authorization: Bearer pb_live_abc123xyz...
X-Search-Engine-Id: your-engine-identifier
```

**完整带过滤器的请求：**
```http
GET https://api.prefixbox.com/search?q=running+shoes&filters={"brand":["Nike","Adidas"],"price_range":{"min":50,"max":200},"size":["8","9","10"]}
Authorization: Bearer pb_live_abc123xyz...
X-Search-Engine-Id: your-engine-identifier
```

**响应格式：**
```json
{
  "search_id": "search_abc123xyz789",
  "query": "running shoes",
  "total_results": 1456,
  "page": 1,
  "page_size": 24,
  "total_pages": 61,
  "latency_ms": 120,
  "products": [
    {
      "id": "prod_67890",
      "name": "Nike Air Zoom Pegasus",
      "description": "Responsive running shoes with Zoom Air cushioning",
      "image": "https://cdn.example.com/nike-pegasus.jpg",
      "price": 129.99,
      "original_price": 159.99,
      "currency": "USD",
      "url": "https://store.example.com/products/nike-air-zoom-pegasus",
      "availability": "in_stock",
      "brand": "Nike",
      "category": "Running Shoes",
      "score": 0.987
    }
  ],
  "filters": [
    {
      "name": "brand",
      "type": "multiselect",
      "values": [
        {"value": "Nike", "count": 456},
        {"value": "Adidas", "count": 389},
        {"value": "Asics", "count": 234}
      ]
    },
    {
      "name": "price",
      "type": "range",
      "min": 29.99,
      "max": 299.99
    },
    {
      "name": "size",
      "type": "multiselect",
      "values": [
        {"value": "7", "count": 156},
        {"value": "8", "count": 234},
        {"value": "9", "count": 289}
      ]
    }
  ],
  "sort_options": [
    {"value": "relevance", "label": "Relevance"},
    {"value": "price_asc", "label": "Price: Low to High"},
    {"value": "price_desc", "label": "Price: High to Low"},
    {"value": "newest", "label": "Newest First"},
    {"value": "popularity", "label": "Most Popular"}
  ],
  "related_keywords": ["trail running", "marathon shoes", "lightweight trainers"],
  "related_categories": [
    {"id": "cat_sports", "name": "Sports & Outdoors"},
    {"id": "cat_footwear", "name": "Footwear"}
  ],
  "personalized": false,
  "ai_reranking": true
}
```

---

### 2.3 商品详情 API (Product Details API)

**端点：** `GET /products/{product_id}`

**功能：** 获取单个商品的详细信息。

**请求示例：**
```http
GET https://api.prefixbox.com/products/prod_67890
Authorization: Bearer pb_live_abc123xyz...
X-Search-Engine-Id: your-engine-identifier
```

**响应格式：**
```json
{
  "id": "prod_67890",
  "name": "Nike Air Zoom Pegasus",
  "description": "Responsive running shoes with Zoom Air cushioning",
  "long_description": "Detailed product description...",
  "images": [
    "https://cdn.example.com/nike-pegasus-1.jpg",
    "https://cdn.example.com/nike-pegasus-2.jpg"
  ],
  "price": 129.99,
  "original_price": 159.99,
  "currency": "USD",
  "url": "https://store.example.com/products/nike-air-zoom-pegasus",
  "availability": "in_stock",
  "stock_quantity": 45,
  "brand": "Nike",
  "category": "Running Shoes",
  "attributes": {
    "color": ["Black", "White", "Blue"],
    "size": ["7", "8", "9", "10", "11", "12"],
    "material": "Mesh and Rubber",
    "weight": "280g"
  },
  "reviews": {
    "average_rating": 4.5,
    "count": 234
  },
  "tags": ["marathon", "neutral", "cushioned"]
}
```

---

### 2.4 分类页面 API (Collection API)

**端点：** `GET /collections/{collection_id}`

**功能：** 获取分类页面的商品列表。

**请求参数：**

| 参数 | 类型 | 说明 |
|------|------|------|
| `collection_id` | string | 分类ID |
| `page` | integer | 页码 |
| `page_size` | integer | 每页数量 |
| `sort` | string | 排序方式 |
| `filters` | object | 过滤器 |

**响应格式：** 与 Search API 类似，但返回的是特定分类的商品

---

## 3. 高级功能 API

### 3.1 个性化搜索 API

**端点：** `GET /search/personalized`

**功能：** 基于用户偏好数据返回个性化排序结果。

**请求参数：**
```json
{
  "q": "running shoes",
  "user_id": "user_12345",
  "cdp_data": {
    "preferred_brands": ["Nike", "Adidas"],
    "preferred_size": "9",
    "preferred_color": "Black",
    "past_purchases": ["prod_111", "prod_222"]
  }
}
```

---

### 3.2 AI 重排序 API

**端点：** `POST /search/rerank`

**功能：** 基于用户行为数据动态重排搜索结果。

**请求参数：**
```json
{
  "search_id": "search_abc123xyz789",
  "user_interactions": {
    "clicks": ["prod_67890", "prod_67891"],
    "hover_time_ms": 2500,
    "previous_searches": ["trail running"]
  }
}
```

---

## 4. 推荐 API (AI Recommend)

### 4.1 相关产品推荐

**端点：** `GET /recommendations/related`

**请求参数：**
```http
GET /recommendations/related?product_id=prod_67890&limit=6
```

**响应格式：**
```json
{
  "product_id": "prod_67890",
  "recommendations": [
    {
      "id": "prod_67891",
      "name": "Nike Dri-FIT Running Socks",
      "reason": "Frequently bought together"
    },
    {
      "id": "prod_67892",
      "name": "Nike Running Cap",
      "reason": "Similar category"
    }
  ]
}
```

---

### 4.2 热门商品推荐

**端点：** `GET /recommendations/trending`

```http
GET /recommendations/trending?category=running&limit=8
```

---

## 5. 分析追踪 API

### 5.1 搜索事件追踪

**端点：** `POST /analytics/search-event`

**功能：** 追踪用户搜索行为以优化搜索相关性。

**事件类型：**
- `search_impression` - 搜索结果展示
- `search_click` - 用户点击结果
- `search_add_to_cart` - 添加商品到购物车
- `search_purchase` - 完成购买

**请求示例：**
```json
{
  "search_id": "search_abc123xyz789",
  "event_type": "search_click",
  "user_id": "user_12345",
  "product_id": "prod_67890",
  "position": 1,
  "timestamp": "2025-01-15T10:30:00Z"
}
```

---

## 6. 实时目录更新 API

**端点：** `POST /catalog/update`

**功能：** 实时更新商品目录数据。

**请求格式：**
```json
{
  "updates": [
    {
      "product_id": "prod_67890",
      "field": "stock_quantity",
      "value": 23,
      "action": "update"
    },
    {
      "product_id": "prod_67891",
      "action": "delete"
    }
  ]
}
```

---

## 7. 错误处理

### 7.1 HTTP 状态码

| 状态码 | 说明 |
|--------|------|
| `200` | 请求成功 |
| `400` | 请求参数错误 |
| `401` | 认证失败 - API Key 无效或缺失 |
| `403` | 权限不足 |
| `404` | 资源未找到 |
| `429` | 请求频率限制 |
| `500` | 服务器内部错误 |

### 7.2 错误响应格式

```json
{
  "error": {
    "code": "INVALID_API_KEY",
    "message": "The provided API key is invalid or expired.",
    "status": 401,
    "request_id": "req_123456789"
  }
}
```

---

## 8. 代码集成示例

### 8.1 JavaScript/Frontend 集成

```javascript
// 初始化 Prefixbox 客户端
const prefixbox = new PrefixboxClient({
  apiKey: 'pb_live_abc123xyz...',
  searchEngineId: 'your-engine-identifier',
  language: 'en'
});

// 自动完成
const suggestions = await prefixbox.autocomplete({
  query: 'run',
  limit: 8
});

// 搜索
const searchResults = await prefixbox.search({
  query: 'running shoes',
  page: 1,
  pageSize: 24,
  filters: {
    brand: ['Nike', 'Adidas'],
    priceRange: { min: 50, max: 200 }
  }
});

// 追踪事件
prefixbox.trackEvent('search_click', {
  searchId: searchResults.searchId,
  productId: 'prod_67890',
  position: 1
});
```

### 8.2 cURL 示例

```bash
# 自动完成
curl -X GET "https://api.prefixbox.com/autocomplete?q=apple&limit=5" \
     -H "Authorization: Bearer pb_live_abc123xyz..." \
     -H "X-Search-Engine-Id: your-engine-identifier"

# 搜索
curl -X GET "https://api.prefixbox.com/search?q=laptop&page=1&page_size=24" \
     -H "Authorization: Bearer pb_live_abc123xyz..." \
     -H "X-Search-Engine-Id: your-engine-identifier"
```

### 8.3 Python 集成示例

```python
import requests

class PrefixboxClient:
    def __init__(self, api_key, search_engine_id):
        self.base_url = "https://api.prefixbox.com"
        self.headers = {
            "Authorization": f"Bearer {api_key}",
            "X-Search-Engine-Id": search_engine_id,
            "Content-Type": "application/json"
        }
    
    def autocomplete(self, query, limit=10):
        endpoint = f"{self.base_url}/autocomplete"
        params = {"q": query, "limit": limit}
        response = requests.get(endpoint, headers=self.headers, params=params)
        return response.json()
    
    def search(self, query, page=1, page_size=24, filters=None):
        endpoint = f"{self.base_url}/search"
        params = {
            "q": query,
            "page": page,
            "page_size": page_size
        }
        if filters:
            params["filters"] = filters
        
        response = requests.get(endpoint, headers=self.headers, params=params)
        return response.json()

# 使用示例
client = PrefixboxClient(
    api_key="pb_live_abc123xyz...",
    search_engine_id="your-engine-identifier"
)

# 执行搜索
results = client.search(
    query="wireless headphones",
    filters={"brand": ["Sony", "Bose"], "price_range": {"min": 100, "max": 300}}
)

print(f"找到 {results['total_results']} 个商品")
for product in results['products']:
    print(f"- {product['name']}: ${product['price']}")
```

---

## 9. SDK 和库

Prefixbox 提供以下官方 SDK：

- **JavaScript SDK**: `npm install @prefixbox/search-js`
- **React SDK**: `npm install @prefixbox/react-search`
- **Python SDK**: `pip install prefixbox-search`
- **PHP SDK**: `composer require prefixbox/search`

---

## 10. 集成方式

### 10.1 API 集成

**适用场景：** 需要完全自定义 UI 和用户体验

**客户职责：**
- 提供商品 Feed URL
- 实现与 Prefixbox API 的通信
- 实现搜索 UX 界面
- 实现用户行为追踪
- Bug 修复和发布

**Prefixbox 职责：**
- 在 Admin Portal 配置搜索模块
- 定制功能需求
- 测试和报告 Bug
- 运行 A/B 测试

### 10.2 前端 JavaScript 集成

**适用场景：** 快速部署，最小化开发工作量

**客户职责：**
- 提供带 header/footer 的空搜索结果页
- 提供商品 Feed URL
- 在网站中插入 Prefixbox JavaScript

**Prefixbox 职责：**
- 配置搜索模块
- 定制外观和功能
- 测试、预览和修复 Bug
- 发布到生产环境

---

## 11. 商品 Feed 格式

Prefixbox 要求提供兼容的商品 Feed：

**必需字段：**
- `id` - 商品唯一标识符
- `name` - 商品名称
- `url` - 商品页面 URL
- `price` - 价格
- `currency` - 货币代码
- `availability` - 库存状态

**推荐字段：**
- `description` - 商品描述
- `image` - 商品图片 URL
- `brand` - 品牌
- `category` - 分类
- `attributes` - 商品属性（颜色、尺寸等）
- `created_at` - 创建日期
- `popularity_score` - 热门度分数

**支持格式：** JSON, XML, CSV

---

## 12. 限制和配额

### 12.1 API 请求限制

| 套餐 | 月请求配额 | 每分钟限制 |
|------|-----------|-----------|
| Starter | 20,000 | 100 |
| Growth | 200,000 | 500 |
| Grow+ | 600,000-900,000 | 1,000 |
| Enterprise | 自定义 | 自定义 |

### 12.2 什么算作 API 请求？

- **自动完成：** 每个字符输入 = 1 次请求
- **搜索：** 每次搜索 = 1 次请求
- **过滤/排序：** 每次操作 = 1 次请求
- **分页：** 每次翻页 = 1 次请求

**示例：** 用户输入 "apple"（6 次自动完成请求）+ 执行搜索（1 次）+ 过滤（1 次）+ 翻页（1 次）= **共 9 次 API 请求**

---

## 13. 支持和资源

### 13.1 官方资源

- **API 文档门户：** https://api-docs.prefixbox.com
- **开发者中心：** https://developers.prefixbox.com
- **技术文档：** https://www.prefixbox.com/en-us/technical
- **集成指南：** https://www.prefixbox.com/en-us/technical/integration

### 13.2 支持级别

| 支持级别 | 可用套餐 | 响应时间 |
|---------|---------|---------|
| 标准支持 | Starter, Growth | 24-48 小时 |
| 高级支持 | Grow+ | 4 小时 |
| 专属支持 | Enterprise | 1 小时 |

---

## 14. 最佳实践

### 14.1 性能优化

1. **缓存自动完成结果** - 减少重复请求
2. **延迟搜索** - 用户停止输入 300ms 后再发送请求
3. **分页加载** - 使用无限滚动或分页
4. **图片优化** - 使用 CDN 和适当尺寸的图片

### 14.2 提升搜索相关性

1. **配置同义词** - 连接不同词汇（如 "sneakers" = "trainers"）
2. **设置字段权重** - 提升重要字段的权重（如 name > description）
3. **使用 A/B 测试** - 测试不同配置对转化率的影响
4. **分析零结果搜索** - 识别缺失商品或查询问题

### 14.3 用户体验

1. **显示搜索建议** - 帮助用户快速找到相关查询
2. **保留搜索上下文** - 支持返回搜索结果
3. **移动端优化** - 确保触摸友好的界面
4. **加载状态** - 提供清晰的加载指示

---

## 15. 常见问题

### Q: API 返回 429 错误怎么办？
A: 表示达到速率限制。实现指数退避重试策略，或升级到更高配额的套餐。

### Q: 如何处理多语言搜索？
A: 在请求中使用 `lang` 参数，并确保商品 Feed 包含翻译内容。

### Q: 可以自定义搜索算法吗？
A: 可以在 Prefixbox Admin Portal 中调整字段权重和同义词规则。

### Q: 支持语音搜索吗？
A: 是的，Prefixbox AI Agent 支持自然语言查询和语音搜索集成。

### Q: 如何集成到移动应用？
A: 通过 API 集成方式，使用 iOS/Android 原生开发或 React Native 调用 REST API。
