


## 2. Python 运行环境

```bash
# 1. 激活 Conda
source /home/tw/miniconda3/etc/profile.d/conda.sh
conda activate searchengine

# 如果部署到新机器，不存在 searchengine 环境时，需要初始化环境：
cd /home/tw/SearchEngine
pip install -r requirements.txt
```

---

## 3. 外部服务与端口

| 服务 | 默认地址 | 说明 |
|------|----------|------|
| Elasticsearch | `http://localhost:9200` | 可通过 Docker 单节点启动 |
| MySQL | `120.79.247.228:3316` | 存放店匠 SPU/SKU 数据 |
| Redis（可选） | `localhost:6479` | Embedding/翻译缓存 |

示例：使用 Docker 启动 Elasticsearch

```bash
docker run -d \
  --name elasticsearch \
  -p 9200:9200 \
  -e "discovery.type=single-node" \
  -e "ES_JAVA_OPTS=-Xms2g -Xmx2g" \
  elasticsearch:8.11.0
```

---

## 4. 环境变量与 `.env` 模板

在项目根目录创建 `.env`，并根据环境替换敏感信息：

```env
# MySQL
DB_HOST=120.79.247.228
DB_PORT=3316
DB_DATABASE=saas
DB_USERNAME=saas
DB_PASSWORD=P89cZHS5d7dFyc9R

# Elasticsearch
ES_HOST=http://localhost:9200
ES_USERNAME=essa
ES_PASSWORD=4hOaLaf41y2VuI8y

# Redis（可选）
REDIS_HOST=localhost
REDIS_PORT=6479
REDIS_PASSWORD=BMfv5aI31kgHWtlx

# DeepL 翻译
DEEPL_AUTH_KEY=c9293ab4-ad25-479b-919f-ab4e63b429ed

# API
API_HOST=0.0.0.0
API_PORT=6002
```

---

## 5. 服务凭证速查

| 项目 | 值 |
|------|----|
| **MySQL** | host `120.79.247.228`, port `3316`, user `saas`, password `P89cZHS5d7dFyc9R` |
| **Elasticsearch** | host `http://localhost:9200`, user `essa`, password `4hOaLaf41y2VuI8y` |
| **Redis（可选）** | host `localhost`, port `6479`, password `BMfv5aI31kgHWtlx` |
| **DeepL** | `c9293ab4-ad25-479b-919f-ab4e63b429ed` |

> 所有凭证仅用于本地/测试环境，生产环境需替换并妥善保管。

---

## 6. 店匠数据源说明

SearchEngine 以 MySQL 中的店匠标准表为权威数据源：

- `shoplazza_product_spu`：SPU 商品主表
- `shoplazza_product_sku`：SKU 变体表

### `shoplazza_product_sku` 字段节选

| 字段 | 类型 | 描述 |
|------|------|------|
| `id` | bigint(20) | SKU 主键 |
| `spu_id` | bigint(20) | 对应 SPU |
| `shop_id` | bigint(20) | 店铺 ID |
| `shoplazza_product_id` | varchar(64) | 店匠商品 ID |
| `title` | varchar(500) | 变体标题 |
| `sku` | varchar(100) | SKU 编码 |
| `price` | decimal(10,2) | 售价 |
| `compare_at_price` | decimal(10,2) | 原价 |
| `option1/2/3` | varchar(255) | 颜色/尺码等选项 |
| `inventory_quantity` | int(11) | 库存 |
| `image_src` | varchar(500) | 图片 |
| `tenant_id` | bigint(20) | 租户 |
| `create_time` | datetime | 创建时间 |
| `update_time` | datetime | 更新时间 |
| `deleted` | bit(1) | 逻辑删除标记 |

> 完整字段、索引映射与 ES 对应关系详见 `INDEX_FIELDS_DOCUMENTATION.md`。

---

## 7. 相关脚本

- `scripts/mock_data.sh`：一次性生成 Tenant1 Mock + Tenant2 CSV 数据并导入 MySQL
- `scripts/ingest.sh <tenant_id> [recreate]`：从 MySQL 写入 Elasticsearch
- `run.sh` / `restart.sh`：服务启动/重启

更多脚本参数、日志与验证命令参见 `USAGE_GUIDE.md` 与 `TEST_DATA_GUIDE.md`。


