# 基础配置指南

## 概述

搜索引擎采用**统一硬编码配置**方案，所有租户共享相同的索引结构和查询配置，无需单独配置。

## 核心特性

- **统一索引结构**: 所有租户共享 `search_products` 索引
- **硬编码配置**: 索引 mapping 和查询配置直接硬编码在代码中，无需配置文件
- **SPU级别索引**: 每个ES文档代表一个SPU，包含嵌套的 `skus` 和 `specifications` 数组
- **租户隔离**: 通过 `tenant_id` 字段实现数据隔离
- **多语言支持**: 文本字段支持中英文双语，后端根据 `language` 参数自动选择

## 索引结构

### Mapping 文件位置

`mappings/search_products.json`

### 主要字段

#### 基础标识
- `tenant_id` (keyword) - 租户ID（必需，用于隔离）
- `spu_id` (keyword) - SPU ID
- `create_time`, `update_time` (date) - 时间字段

#### 多语言文本字段
- `title_zh`, `title_en` (text) - 标题（中英文）
- `brief_zh`, `brief_en` (text) - 短描述（中英文）
- `description_zh`, `description_en` (text) - 详细描述（中英文）
- `vendor_zh`, `vendor_en` (text) - 供应商/品牌（中英文，含keyword子字段）
- `category_path_zh`, `category_path_en` (text) - 类目路径（中英文）
- `category_name_zh`, `category_name_en` (text) - 类目名称（中英文）

#### 类目字段
- `category_id` (keyword) - 类目ID
- `category_name` (keyword) - 类目名称
- `category_level` (integer) - 类目层级
- `category1_name`, `category2_name`, `category3_name` (keyword) - 多级类目

#### 规格和选项
- `specifications` (nested) - 规格列表（name, value, sku_id）
- `option1_name`, `option2_name`, `option3_name` (keyword) - 选项名称

#### 价格和库存
- `min_price`, `max_price`, `compare_at_price` (float) - 价格字段
- `sku_prices` (float) - SKU价格列表（数组）
- `sku_weights` (long) - SKU重量列表（数组）
- `sku_weight_units` (keyword) - SKU重量单位列表（数组）
- `total_inventory` (long) - 总库存

#### 嵌套字段
- `skus` (nested) - SKU详细信息数组
- `image_embedding` (nested) - 图片向量（仅用于搜索）

#### 其他
- `tags` (keyword) - 标签列表（数组）
- `image_url` (keyword, index: false) - 主图URL
- `title_embedding` (dense_vector) - 标题向量（仅用于搜索，不返回）

## 查询配置

### 文本召回字段

默认同时搜索以下字段（中英文都包含）：
- `title_zh^3.0`, `title_en^3.0`
- `brief_zh^1.5`, `brief_en^1.5`
- `description_zh^1.0`, `description_en^1.0`
- `vendor_zh^1.5`, `vendor_en^1.5`
- `category_path_zh^1.5`, `category_path_en^1.5`
- `category_name_zh^1.5`, `category_name_en^1.5`
- `tags^1.0`

### 查询架构

**结构**: `filters AND (text_recall OR embedding_recall)`

- **filters**: 前端传递的过滤条件（永远起作用）
- **text_recall**: 文本相关性召回（同时搜索中英文字段）
- **embedding_recall**: 向量召回（KNN，使用 `title_embedding`）
- **function_score**: 包装召回部分，支持提权字段

### Function Score 配置

位置: `search/query_config.py` 中的 `FUNCTION_SCORE_CONFIG`

支持的类型：
- `filter_weight`: 条件权重（如新品提权）
- `field_value_factor`: 字段值因子（如销量因子）
- `decay`: 衰减函数（如时间衰减）

## 分面配置

### 默认分面字段

- `category1_name` - 一级类目
- `category2_name` - 二级类目
- `category3_name` - 三级类目
- `specifications` - 规格分面（嵌套聚合，按name分组，然后按value聚合）

### 规格分面说明

`specifications` 使用特殊的嵌套聚合：
- 按 `specifications.name` 分组（如"color"、"size"）
- 每个 `name` 下按 `specifications.value` 聚合（如"white"、"black"）

返回格式：
```json
{
  "field": "specifications.color",
  "label": "color",
  "type": "terms",
  "values": [
    {"value": "white", "count": 50},
    {"value": "black", "count": 30}
  ]
}
```

## 返回字段映射

后端根据请求的 `language` 参数（`zh` 或 `en`）自动选择对应的中英文字段：

- `language="zh"`: 优先返回 `*_zh` 字段，如果为空则回退到 `*_en` 字段
- `language="en"`: 优先返回 `*_en` 字段，如果为空则回退到 `*_zh` 字段

映射规则：
- `title_zh/en` → `title`
- `brief_zh/en` → `brief`
- `description_zh/en` → `description`
- `vendor_zh/en` → `vendor`
- `category_path_zh/en` → `category_path`
- `category_name_zh/en` → `category_name`

## 配置修改

### 修改索引结构

编辑 `mappings/search_products.json`，然后：
1. 删除旧索引: `scripts/recreate_and_import.py --recreate`
2. 重新导入数据: `scripts/ingest.sh <tenant_id> true`

### 修改查询配置

编辑 `search/query_config.py`:
- `DEFAULT_MATCH_FIELDS`: 文本召回字段列表
- `FUNCTION_SCORE_CONFIG`: Function score 配置
- `DEFAULT_FACETS`: 默认分面字段

### 修改返回字段

编辑 `search/query_config.py` 中的 `SOURCE_FIELDS` 列表。

## 注意事项

1. **无需配置文件**: 所有配置都是硬编码的，不需要为每个租户创建配置文件
2. **统一结构**: 所有租户共享相同的索引结构和查询逻辑
3. **多租户隔离**: 所有查询必须包含 `tenant_id` 过滤条件
4. **向量字段**: `title_embedding` 和 `image_embedding` 仅用于搜索，不会返回给前端

## 相关文档

- `索引字段说明v2.md` - 详细的字段说明
- `搜索API对接指南.md` - API使用说明
- `mappings/search_products.json` - 索引 mapping 定义
