# 商品导入模板说明文档

本文档完整描述了商品导入Excel模板的结构、字段说明和示例数据。

## 字段列表

| 列号 | 字段名称 | 字段说明 |
|------|----------|----------|
| 1 | 商品ID | （此行导入时不可删除 ）商品 ID 是系统生成的唯一标识符，新增商品无需填写 |
| 2 | 创建时间 | 创建时间的时区为当前店铺设置的时区 |
| 3 | 商品标题* | 最多255字符(同一商品的子款式标题与商品标题需一致，且中间请勿插入其他商品) |
| 4 | 商品属性* | 1.多款式商品：<br>同一个商品的首行标题填入「M」（商品主体)；<br>同一个商品的非首行标题填入「P」(子款式)；<br>2.单一款式商品（Single）：填入「S」 |
| 5 | 商品副标题 | 最多600字符 |
| 6 | 商品描述 | 上传不带样式，若需要样式，则输入html代码 |
| 7 | SEO标题 | 最多5000字符 |
| 8 | SEO描述 | 最多5000字符 |
| 9 | SEO URL Handle | 最多支持输入255字符<br>（SEO URL handle只对SEO URL的「URL参数」部分进行更改，即“products/”后的内容，如：products/「URL参数」<br>） |
| 10 | SEO URL 重定向 | 创建URL重定向，访问修改前链接可跳转到修改后的新链接页面<br>「Y」:TRUE <br>「N」:FALSE  |
| 11 | SEO关键词 | 多个关键词请用「英文逗号」隔开 |
| 12 | 商品上架 | 「Y」:上架状态<br>「N」:下架状态<br>默认为「N」 |
| 13 | 需要物流 | 「Y」:需要<br>「N」:不需要<br>默认为「Y」 |
| 14 | 商品收税 | 「Y」:需要<br>「N」:不需要<br>默认为「N」 |
| 15 | 商品spu | 最多100字符 |
| 16 | 启用虚拟销量 | 「Y」:启用<br>「N」:不启用<br>默认为「N」 |
| 17 | 虚拟销量值 | 最多输入六位数的自然数 |
| 18 | 跟踪库存 | 「Y」:跟踪<br>「N」:不跟踪<br>默认为「N」 |
| 19 | 库存规则* | 若跟踪库存为Y，则该项必填：<br>填入「1」表示：库存为0允许购买<br>填入「2」表示：库存为0不允许购买<br>填入「3」表示：库存为0自动下架 |
| 20 | 专辑名称 | 请填入已创建的手动专辑名称；<br>多个专辑请用「英文逗号」隔开 |
| 21 | 标签 | 最多输入250个标签，每个不得超过500字符，多个标签请用「英文逗号」隔开 |
| 22 | 供应商名称 | 最多20字符 |
| 23 | 供应商URL | 请输入供应商URL |
| 24 | 款式1 | 最多255字符 |
| 25 | 款式2 | 最多255字符 |
| 26 | 款式3 | 最多255字符 |
| 27 | 商品售价* | 最多输入9位正整数，2位小数 |
| 28 | 商品原价 | 最多输入9位正整数，2位小数 |
| 29 | 成本价 | 最多输入9位正整数，2位小数 |
| 30 | 商品SKU | 最多255字符 |
| 31 | 商品重量 | 最多输入10位正整数，2位小数 |
| 32 | 重量单位 | 可选单位有：kg, lb, g, oz；<br>默认为kg |
| 33 | 商品条形码 | 最多100字符 |
| 34 | 商品库存 | 只支持导入默认地点库存，如需导入其他地点的库存，请到【库存列表】导入。最多输入9位整数 |
| 35 | 尺寸信息 | 按长宽高顺序填写，用「英文逗号」隔开，单位默认为英寸 |
| 36 | 原产地国别 | 请填写国家代码 |
| 37 | HS（协调制度）代码 | 6-12纯数字 |
| 38 | 商品图片* | 商品属性为M(商品主体)与S(单一款式商品)的行可填入商品图URL：<br>1.若商品主图字段有值，则填入的图片URL为商品副图（可选填）<br>2.若商品主图字段为空，则必须至少填入一个图片URL，且首个URL为商品主图URL，其他为商品副图<br>3.填多个URL可用「英文逗号」隔开<br><br>商品属性为P(子款式)的行可填入子款式图URL：<br>1.仅支持填入一个URL作为子款式图片，填入多个时默认导入第一个；若不填入，则默认不需要图片<br>2.同一商品的部分子款式上传图片，则其余款式也需要上传，否则默认填入商品主图<br> |
| 39 | 商品备注 | 最多输入500个字 |
| 40 | 款式备注 | 最多输入20个字 |
| 41 | 商品主图 | 1.只需商品属性为M(商品主体)与S(单一款式商品)的行填写（可选填）<br>2.仅能填入一个图片URL作为商品主图，填入多个时默认只导入第一个 |
| 42 | 如需导入元字段， 请在此行增添【元字段-命名空间和密钥】作为表头，例：元字段-test.111 | 1. 请确认导入的元字段在店铺后台已创建；<br>2. 只需商品属性为M(商品主体)与S(单一款式商品)的行填写元字段值（可选填）<br>3.各类型元字段填写规范详见帮助文档：https://helpcenter.shoplazza.com/hc/zh-cn/articles/37520605874457 |

## 示例数据

模板中包含以下示例数据，展示了多款式商品（M+P）和单一款式商品（S）的格式：

### 商品示例：Legendary Whitetails Men's Buck Camp Flannel Shirt

#### 行 4 - 商品属性: M

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `M`
- 商品副标题: `100% Cotton
We recommend ordering a size down if you prefer a closer fit
Purchase from Amazon seller Legendary Whitetails to ensure you receive an authentic Legendary Whitetails branded Buck Camp F...`
- 商品描述: `<p>A hunter&rsquo;s wardrobe is not complete without a great flannel. Our exclusive plaids are made from 100% cotton soft brushed flannel. Featuring double pleat back for ease of movement and contr...`

**SEO信息:**
- SEO标题: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- SEO描述: `Featuring double pleat back for ease of movement and contrasting corduroy lined collar and cuffs for a great look and lasting durability.`
- SEO URL Handle: `products/maternity-lace-cardigan-dress-photo-shoot_3a09`
- SEO关键词: `新品,热卖,爆款`

**状态设置:**
- 商品上架: `Y`
- 需要物流: `Y`
- 商品收税: `Y`
- 启用虚拟销量: `N`
- 虚拟销量值: `100`
- 跟踪库存: `Y`
- 库存规则*: `1`

**分类信息:**
- 专辑名称: `衬衣,热卖`
- 标签: `新品,热卖,爆款`
- 供应商名称: `Amazon`
- 供应商URL: `https://www.amazon.com/Legendary-Whitetails-Buck-Flannels-Large/dp/B01KTUMBOI/ref=sr_1_1?s=fashion-mens-intl-ship&ie=UTF8&qid=1543038722&sr=1-1`

**款式信息:**
- 款式1: `SIZE`
- 款式2: `COLOR`

**其他信息:**
- 商品图片*: `https://m.media-amazon.com/images/S/aplus-seller-content-images-us-east-1/ATVPDKIKX0DER/A1ABYS4IVXNT9X/27b061cf-ccd1-4c4c-82fd-6519a84b60c3.jpg`

#### 行 5 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `S`
- 款式2: `red`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-RD-S1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 6 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `S`
- 款式2: `black`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-BK-S1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 7 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `S`
- 款式2: `army`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-AM-S1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 8 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `L`
- 款式2: `red`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-RD-M1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 9 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `L`
- 款式2: `black`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-BK-M1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 10 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `L`
- 款式2: `army`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-AM-M1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 11 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `XL`
- 款式2: `red`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-RD-L1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 12 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `XL`
- 款式2: `black`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-BK-L1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

#### 行 13 - 商品属性: P

**基本信息:**
- 商品标题*: `Legendary Whitetails Men's Buck Camp Flannel Shirt`
- 商品属性*: `P`

**款式信息:**
- 款式1: `XL`
- 款式2: `army`

**价格库存:**
- 商品售价*: `88.99`
- 商品原价: `149.99`
- 商品SKU: `LW-TS-AM-L1`
- 商品重量: `0.2`
- 重量单位: `kg`
- 商品库存: `100`

---

### 商品示例：Jabra Move Wireless Stereo Headphones

#### 行 14 - 商品属性: S

**基本信息:**
- 商品标题*: `Jabra Move Wireless Stereo Headphones`
- 商品属性*: `S`
- 商品副标题: `Listen to your tunes and never miss a call
Ultra-lightweight and adjustable headband fits all head-types
Durable stainless steel headband and dirt resistant fabric for life on the move.40mm Dynamic...`
- 商品描述: `Clean Scandinavian design meets crisp digital sound. Get a perfect fit with the ultra-light, comfortable headband. Choose from four modern colors: Cayenne (Red), Cobalt (Blue), Coal (Black) and Gold.`

**SEO信息:**
- SEO URL Handle: `products/maternity-rainbow-stripe-skinny-bodycon-dress_5027`

**状态设置:**
- 商品上架: `Y`
- 需要物流: `Y`
- 商品收税: `N`
- 启用虚拟销量: `N`
- 虚拟销量值: `100`
- 跟踪库存: `N`
- 库存规则*: `2`

**分类信息:**
- 专辑名称: `头戴式耳机`
- 标签: `耳机,头戴式,爆款`
- 供应商名称: `Amazon`
- 供应商URL: `https://www.amazon.com/Jabra-Move-Wireless-Stereo-Headphones/dp/B00MR8Z28S/ref=br_asw_pdt-2?pf_rd_m=ATVPDKIKX0DER&pf_rd_s=&pf_rd_r=8NAPN9R973J85P2KDX4G&pf_rd_t=36701&pf_rd_p=a08731ea-e1c2-4f7f-a56e...`

**价格库存:**
- 商品售价*: `49.99`
- 商品原价: `99.99`
- 商品SKU: `B00MR8Z28S`
- 商品重量: `0.3`
- 重量单位: `lb`
- 商品库存: `500`

**其他信息:**
- 商品图片*: `https://images-na.ssl-images-amazon.com/images/I/416k5ZUd6lL.jpg`

---


## 重要说明

### 商品属性字段说明

商品属性字段是必填项，用于标识商品类型：

- **M (商品主体)**: 多款式商品的首行，填写商品主体信息
  - 需要填写：商品标题、描述、SEO信息、分类等商品主体信息
  - 不需要填写：价格、库存、SKU等子款式信息

- **P (子款式)**: 多款式商品的非首行，填写子款式信息
  - 需要填写：商品标题（与M行一致）、款式值、价格、库存、SKU等
  - 不需要填写：商品描述、SEO信息等商品主体信息

- **S (单一款式商品)**: 单一款式商品，一行包含所有信息
  - 需要填写：所有商品信息，包括标题、描述、价格、库存等

### 字段填写规则

1. **商品ID**: 系统自动生成，新增商品无需填写
2. **商品标题***: 必填，最多255字符。同一商品的子款式标题必须与商品主体标题一致
3. **商品属性***: 必填，只能填写 M、P 或 S
4. **商品售价***: 必填，最多9位正整数，2位小数
5. **商品SKU**: 必填，最多255字符
6. **商品图片***: 必填（M和S类型），可填写多个图片URL，用逗号分隔
7. **库存规则***: 当跟踪库存为Y时必填，可选值：1（库存为0允许购买）、2（库存为0不允许购买）、3（库存为0自动下架）

### 数据格式要求

- 日期时间格式：`YYYY-MM-DD HH:MM:SS`
- 布尔值：使用 `Y` 或 `N`
- 多个值：使用英文逗号分隔
- HTML内容：商品描述支持HTML代码
- URL格式：图片URL和供应商URL需为完整URL

### 注意事项

1. 同一商品的子款式行必须紧跟在商品主体行之后，中间不能插入其他商品
2. 商品标题在所有子款式行中必须保持一致
3. 图片URL必须是可访问的完整URL
4. 价格、库存等数值字段不能包含非数字字符（除小数点外）
5. 导入前请确保所有必填字段都已正确填写

