https://help.aliyun.com/zh/open-search/industry-algorithm-edition/e-commerce?spm=a2c4g.11186623.help-menu-29102.d_3_2_1.5a903cfbxOsaHt&scm=20140722.H_99739._.OR_help-T_cn~zh-V_1


## 定义应用结构
示例如下：
| 字段名称       | 主键 | 字段标签   | 类型         |
|----------------|------|------------|--------------|
| title          |      | 商品标题   | TEXT         |
| text_embedding |      | 文本向量   | EMBEDDING         |
| image_embedding |      | 图片向量   | EMBEDDING         |
| category_name  |      | 类目名称   | TEXT         |
| image_url      |      |            | LITERAL_ARRAY|
| description    |      | 商品描述   | TEXT         |
| brand_name     |      | 品牌名称   | TEXT         |
| thumbnail_url  |      |            | LITERAL_ARRAY|
| is_onsale      |      |            | INT          |
| url            |      |            | LITERAL      |
| brand_id       |      |            | LITERAL      |
| series_id      |      |            | LITERAL      |
| sold_num       |      | 商品销量   | INT          |
| category_id    |      |            | INT          |
| onsale_time    |      | 上架时间   | INT          |
| price          |      |            | DOUBLE       |
| series_name    |      |            | TEXT         |
| discount_price |      | DOUBLE |
| pid            | ●    | INT    |
| sale_price     |      | DOUBLE |
| act_price      |      | DOUBLE |


## 定义索引结构

| 索引名称 | 索引标签 | 包含字段 | 分析方式 | 使用示例 |
| --- | --- | --- | --- | --- |
| default | 默认索引 | category_name, description, brand_name, title, create_by, update_by | 行业 - 电商通用分析 | query=default:“云搜索” |
| category_name | 类目名称索引 | category_name | 行业 - 电商通用分析 | query=category_name:“云搜索” |
| category_id |  | category_id | 关键字 | query=category_id:“云搜索” |
| series_name |  | series_name | 中文 - 通用分析 | query=series_name:“云搜索” |
| brand_name |  | brand_name | 中文 - 通用分析 | query=brand_name:“云搜索” |
| id |  | id | 关键字 | query=id:“云搜索” |
| title | 标题索引 | title | 行业 - 电商通用分析 | query=title:“云搜索” |
| seller_id |  | seller_id | 关键字 | query=seller_id:“云搜索” |
| brand_id |  | brand_id | 关键字 | query=brand_id:“云搜索” |
| series_id |  | series_id | 关键字 | query=series_id:“云搜索” |

上面的只是阿里云的opensearch的例子，我们也要有同样的一套配置，这里支持的“字分析方式” 为ES预先支持的 多种分析器，我们要支持的分析方式参考 @商品数据源入ES配置规范.md

