# 使用指南 - SearchEngine

本文档提供完整的使用指南，包括环境准备、服务启动、配置说明、日志查看等。

## 目录

1. [环境准备](#环境准备)
2. [服务启动](#服务启动)
3. [配置说明](#配置说明)
4. [查看日志](#查看日志)
5. [测试验证](#测试验证)
6. [常见问题](#常见问题)

---

## 环境准备

### 系统要求

- **操作系统**: Linux (推荐 CentOS 7+ / Ubuntu 18.04+)
- **Python**: 3.8+
- **内存**: 建议 8GB+
- **磁盘**: 10GB+ (包含模型文件)
- **Elasticsearch**: 8.x (可通过Docker运行)

### 安装依赖

#### 1. 安装Python依赖

```bash
cd /home/tw/SearchEngine
pip install -r requirements.txt
```

#### 2. 启动Elasticsearch

**方式1: 使用Docker（推荐）**

```bash
docker run -d \
  --name elasticsearch \
  -p 9200:9200 \
  -e "discovery.type=single-node" \
  -e "ES_JAVA_OPTS=-Xms2g -Xmx2g" \
  elasticsearch:8.11.0
```

**方式2: 本地安装**

参考 [Elasticsearch官方文档](https://www.elastic.co/guide/en/elasticsearch/reference/8.11/install-elasticsearch.html)

#### 3. 配置环境变量

创建 `.env` 文件：

```bash
# MySQL配置
DB_HOST=120.79.247.228
DB_PORT=3316
DB_DATABASE=saas
DB_USERNAME=saas
DB_PASSWORD=your_password

# Elasticsearch配置
ES_HOST=http://localhost:9200
ES_USERNAME=essa
ES_PASSWORD=4hOaLaf41y2VuI8y

# Redis配置（可选，用于缓存）
REDIS_HOST=localhost
REDIS_PORT=6479
REDIS_PASSWORD=BMfv5aI31kgHWtlx

# DeepL翻译API（可选）
DEEPL_AUTH_KEY=c9293ab4-ad25-479b-919f-ab4e63b429ed

# API服务配置
API_HOST=0.0.0.0
API_PORT=6002
```

---

## 服务启动

### 方式1: 一键启动（推荐）

```bash
cd /home/tw/SearchEngine
./run.sh
```

这个脚本会自动：
1. 创建日志目录
2. 启动后端API服务（后台运行）
3. 启动前端Web界面（后台运行）
4. 等待服务就绪

启动完成后，访问：
- **前端界面**: http://localhost:6003
- **后端API**: http://localhost:6002
- **API文档**: http://localhost:6002/docs

### 方式2: 分步启动

#### 启动后端服务

```bash
./scripts/start_backend.sh
```

后端API会在 http://localhost:6002 启动

#### 启动前端服务

```bash
./scripts/start_frontend.sh
```

前端界面会在 http://localhost:6003 启动

### 方式3: 手动启动

#### 启动后端API服务

```bash
python -m api.app \
  --host 0.0.0.0 \
  --port 6002 \
  --es-host http://localhost:9200 \
  --reload
```

#### 启动前端服务（可选）

```bash
# 使用Python简单HTTP服务器
cd frontend
python -m http.server 6003
```

### 停止服务

```bash
# 停止后端
kill $(cat logs/backend.pid)

# 停止前端
kill $(cat logs/frontend.pid)

# 或使用停止脚本
./scripts/stop.sh
```

### 服务端口

| 服务 | 端口 | URL |
|------|------|-----|
| Elasticsearch | 9200 | http://localhost:9200 |
| Backend API | 6002 | http://localhost:6002 |
| Frontend Web | 6003 | http://localhost:6003 |
| API Docs | 6002 | http://localhost:6002/docs |

---

## 配置说明

### 环境配置文件 (.env)

主要配置项说明：

```bash
# Elasticsearch配置
ES_HOST=http://localhost:9200
ES_USERNAME=essa
ES_PASSWORD=4hOaLaf41y2VuI8y

# MySQL配置
DB_HOST=120.79.247.228
DB_PORT=3316
DB_DATABASE=saas
DB_USERNAME=saas
DB_PASSWORD=your_password

# Redis配置（可选，用于缓存）
REDIS_HOST=localhost
REDIS_PORT=6479
REDIS_PASSWORD=BMfv5aI31kgHWtlx

# DeepL翻译API
DEEPL_AUTH_KEY=c9293ab4-ad25-479b-919f-ab4e63b429ed

# API服务配置
API_HOST=0.0.0.0
API_PORT=6002
```

### 修改配置

1. 编辑 `.env` 文件
2. 重启相关服务

---

## 查看日志

### 日志文件位置

日志文件存储在 `logs/` 目录下：

- `logs/backend.log` - 后端服务日志
- `logs/frontend.log` - 前端服务日志
- `logs/search_engine.log` - 应用主日志（按天轮转）
- `logs/errors.log` - 错误日志（按天轮转）

### 查看实时日志

```bash
# 查看后端日志
tail -f logs/backend.log

# 查看前端日志
tail -f logs/frontend.log

# 查看应用主日志
tail -f logs/search_engine.log

# 查看错误日志
tail -f logs/errors.log
```

### 日志级别

日志级别可以通过环境变量 `LOG_LEVEL` 设置：

```bash
# 在 .env 文件中设置
LOG_LEVEL=DEBUG  # DEBUG, INFO, WARNING, ERROR, CRITICAL
```

### 日志轮转

日志文件按天自动轮转，保留30天的历史日志。

---

## 测试验证

### 1. 健康检查

```bash
curl http://localhost:6002/admin/health
```

**预期响应**:
```json
{
  "status": "healthy",
  "elasticsearch": "connected"
}
```

### 2. 索引统计

```bash
curl http://localhost:6002/admin/stats
```

### 3. 简单搜索测试

```bash
curl -X POST http://localhost:6002/search/ \
  -H "Content-Type: application/json" \
  -H "X-Tenant-ID: 162" \
  -d '{
    "query": "玩具",
    "size": 10
  }'
```

或者通过查询参数：

```bash
curl -X POST "http://localhost:6002/search/?tenant_id=2" \
  -H "Content-Type: application/json" \
  -d '{
    "query": "玩具",
    "size": 10
  }'
```

### 4. 带过滤器的搜索

```bash
curl -X POST http://localhost:6002/search/ \
  -H "Content-Type: application/json" \
  -H "X-Tenant-ID: 162" \
  -d '{
    "query": "玩具",
    "size": 10,
    "filters": {
      "category.keyword": ["玩具", "益智玩具"]
    },
    "range_filters": {
      "price": {"gte": 50, "lte": 200}
    }
  }'
```

### 5. 分面搜索测试

```bash
curl -X POST http://localhost:6002/search/ \
  -H "Content-Type: application/json" \
  -H "X-Tenant-ID: 162" \
  -d '{
    "query": "玩具",
    "size": 10,
    "facets": [
      {"field": "category.keyword", "size": 15},
      {"field": "vendor.keyword", "size": 15}
    ]
  }'
```

### 6. 图片搜索测试

```bash
curl -X POST http://localhost:6002/search/image \
  -H "Content-Type: application/json" \
  -H "X-Tenant-ID: 162" \
  -d '{
    "image_url": "https://oss.essa.cn/example.jpg",
    "size": 10
  }'
```

### 7. 前端界面测试

访问 http://localhost:6003 或 http://localhost:6002/ 进行可视化测试。

**注意**: 所有搜索接口都需要通过 `X-Tenant-ID` 请求头或 `tenant_id` 查询参数指定租户ID。

---

## 常见问题

### Q1: MySQL连接失败

**症状**: `Failed to connect to MySQL`

**解决方案**:
```bash
# 检查MySQL服务状态
mysql -h 120.79.247.228 -P 3316 -u saas -p -e "SELECT 1"

# 检查配置
cat .env | grep DB_
```

### Q2: Elasticsearch连接失败

**症状**: `Failed to connect to Elasticsearch`

**解决方案**:
```bash
# 检查ES服务状态
curl http://localhost:9200

# 检查ES版本
curl http://localhost:9200 | grep version

# 确认配置
cat .env | grep ES_
```

### Q3: 服务启动失败

**症状**: `Address already in use` 或端口被占用

**解决方案**:
```bash
# 查看占用端口的进程
lsof -i :6002  # 后端
lsof -i :6003  # 前端
lsof -i :9200  # ES

# 杀掉进程
kill -9 <PID>

# 或修改端口配置
```

### Q4: 搜索无结果

**症状**: 搜索返回空结果

**解决方案**:
```bash
# 检查ES中是否有数据
curl http://localhost:9200/search_products/_count

# 检查tenant_id过滤是否正确
curl -X POST http://localhost:6002/search/ \
  -H "Content-Type: application/json" \
  -H "X-Tenant-ID: 162" \
  -d '{"query": "*", "size": 10, "debug": true}'
```

### Q5: 前端无法连接后端

**症状**: CORS错误

**解决方案**:
- 确保后端在 http://localhost:6002 运行
- 检查浏览器控制台错误信息
- 检查后端日志中的CORS配置

### Q6: 翻译不工作

**症状**: 翻译返回原文

**解决方案**:
- 检查DEEPL_AUTH_KEY是否正确
- 如果没有API key，系统会使用mock模式（返回原文）

---

## 相关文档

- **测试数据构造文档**: `TEST_DATA_GUIDE.md` - 如何构造和导入测试数据
- **API接口文档**: `API_INTEGRATION_GUIDE.md` - 完整的API对接指南
- **字段说明文档**: `INDEX_FIELDS_DOCUMENTATION.md` - 索引字段详细说明
- **设计文档**: `设计文档.md` - 系统架构和设计说明
- **README**: `README.md` - 项目概述和快速开始

---

**文档版本**: v2.0  
**最后更新**: 2024-12

