# Comprehensive Apparel Tagging System (7-Dimensional Framework)

This tagging system covers all apparel categories from mass-market to niche segments, optimized for e-commerce, inventory management, and AI-powered recommendation engines.

---

## **1. Style (Aesthetic & Design Philosophy)**

### **Core Contemporary Styles**
- Bohemian, Cottagecore, Coastal Grandma, Dark Academia, Light Academia, Y2K, Indie Sleaze, Preppy, Normcore, Minimalist, Maximalist, Athleisure, Streetwear, Gorpcore, Baddie, Coquette, Mermaidcore, Barbiecore, Balletcore, Angelcore, Fairy Grunge, Goblincore, Witchy, Gothic, Punk, Emo, Grunge, Steampunk, Cyberpunk, Cosplaycore, E-Girl, E-Boy, VSCO, Soft Girl, Clean Girl, Vanilla Girl, Tomato Girl, Latte Makeup, Mob Wife, Old Money, Quiet Luxury

### **Classic & Commercial Styles**
- Classic, Traditional, Vintage (1920s-1990s), Retro, Modern, Contemporary, Timeless, Elegant, Sophisticated, Chic, Casual, Smart Casual, Business Casual, Formal, Black Tie, White Tie, Resort, Safari, Western, Country, Military, Utility, Workwear, Lagenlook, Artsy, Eclectic, Romantic, Feminine, Androgynous, Gender-fluid, Unisex, Masculine, Tomboy, Girly, Sexy, Demure, Modest, Conservative, Avant-garde, Deconstructed, Oversized, Fitted

### **Designer & Trend-driven Styles**
- Runway, Haute Couture, Ready-to-Wear, Avant-garde, Minimalist Luxe, Brutalist, Sculptural, Architectural, Deconstructivist, Up-cycled, Artisanal, Handcrafted, Bespoke, Tailored, Made-to-Measure, Custom, Personalized, DIY, Upcycled, Sustainable, Ethical, Vegan, Cruelty-free, Fair Trade, Slow Fashion, Fast Fashion

---

## **2. Occasion (Use Case & Context)**

### **Formal & Ceremonial**
- Wedding (Bride, Bridesmaid, Mother of Bride, Wedding Guest), Black Tie, White Tie, Gala, Awards Ceremony, Red Carpet, Charity Ball, Debutante, Prom, Homecoming, Graduation, Quinceañera, Bat Mitzvah, Cocktail Party, Engagement Party, Bridal Shower, Baby Shower, Bachelorette Party, Baptism, Confirmation, Bar Mitzvah

### **Professional & Business**
- Board Meeting, Client Presentation, Job Interview, Daily Office, Business Travel, Conference, Trade Show, Networking, Corporate Event, Business Dinner, Office Party, Casual Friday, Work From Home, Business Casual, Smart Casual

### **Social & Entertainment**
- Date Night, Dinner Party, Girls Night Out, Clubbing, Bar Hopping, Concert, Music Festival, Rave, Comedy Show, Theater, Opera, Ballet, Art Gallery Opening, Museum Visit, Casino Night, Speed Dating, Singles Event

### **Active & Outdoor**
- Gym Workout, CrossFit, HIIT, Yoga (Hot Yoga, Vinyasa, Restorative), Pilates, Barre, Spin Class, Running, Marathon, Trail Running, Hiking, Trekking, Camping, Backpacking, Rock Climbing, Mountaineering, Bouldering, Cycling (Road, Mountain, Commute), Mountain Biking, Skiing, Snowboarding, Ice Skating, Snowshoeing, Surfing, Swimming, Beach Volleyball, Tennis, Golf, Horseback Riding, Fishing, Hunting, Sailing, Kayaking, Canoeing, Paddleboarding, Rafting, Scuba Diving, Snorkeling, Windsurfing, Kitesurfing, Triathlon, Obstacle Course Racing

### **Casual & Daily Life**
- Weekend Errands, Grocery Shopping, Farmers Market, Brunch, Coffee Date, Dog Walking, School Drop-off, Park Playground, Library, Study Session, Lecture, Class, Campus, Dorm Life, Apartment Living, Suburban Life, Urban Commute, Public Transit, Bike Commute, Motorcycle Ride, Road Trip, Car Travel, Train Travel, Flight Travel, Airport, Layover, Sightseeing, Museum Hopping, City Tour

### **Seasonal & Holiday**
- Spring Break, Summer Vacation, Fall Foliage Tour, Winter Holiday, Christmas, Hanukkah, Kwanzaa, New Year's Eve, Valentine's Day, St. Patrick's Day, Easter, Fourth of July, Halloween, Thanksgiving, Holiday Party, Ugly Sweater Party, New Year's Resolution, Summer Solstice, Winter Solstice

### **Milestone & Life Events**
- Pregnancy Announcement, Maternity Photoshoot, Gender Reveal, Baby Shower, Postpartum Recovery, Nursing-friendly, Breastfeeding, Back-to-Work Postpartum, First Day of School, Last Day of School, Graduation, First Job, Retirement, Empty Nester, Golden Anniversary, Silver Anniversary, Engagement Photos, Boudoir Photoshoot, Family Photos, Holiday Card Photo

---

## **3. Category (Garment Type)**

### **Tops**
- T-Shirt, Tank Top, Camisole, Spaghetti Strap, Halter Top, Tube Top, Crop Top, Bra Top, Sports Bra, Longline Bra, Bodysuit, Teddie, Bodice, Blouse, Shirt, Button-Down, Oxford Shirt, Chambray Shirt, Denim Shirt, Flannel Shirt, Polo Shirt, Rugby Shirt, Henley, Tunic, Kimono, Kaftan, Caftan, Poncho, Cape, Shawl, Wrap, Cardigan, Sweater, Pullover, Jumper, Sweatshirt, Hoodie, Zip-Up, Quarter-Zip, Turtleneck, Mock Neck, Cowl Neck, Boat Neck, Off-Shoulder, One-Shoulder, Cold-Shoulder, Bardot, Peplum Top, Empire Waist Top, Basque Waist Top, Baby Doll Top, Smocked Top, Ruched Top, Gathered Top

### **Bottoms**
- Jeans (Skinny, Slim, Straight, Bootcut, Flare, Wide Leg, Palazzo, Cropped, Ankle, Capri, Boyfriend, Girlfriend, Mom, Dad), Pants (Dress Pants, Trousers, Slacks, Chinos, Khakis, Cargo Pants, Carpenter Pants, Work Pants, Uniform Pants), Leggings (Yoga Leggings, Compression Leggings, Fashion Leggings, Jeggings, Treggings), Joggers, Sweatpants, Track Pants, Shorts (Denim Shorts, Bermuda Shorts, Cargo Shorts, Athletic Shorts, Bike Shorts, Board Shorts, Chino Shorts, Lounge Shorts, Sleep Shorts), Skirt (Mini, Midi, Maxi, Micro, Knee-Length, Tea-Length, Floor-Length), Skort, Culottes, Gaucho Pants, Harem Pants, Hammer Pants, Parachute Pants, Drop-Crotch Pants, Peg Pants, Cigarette Pants

### **Dresses & Jumpsuits**
- Dress (Mini, Midi, Maxi, Micro, Knee-Length, Tea-Length, Floor-Length, Ankle-Length), Sundress, Slip Dress, Cami Dress, Spaghetti Strap Dress, Halter Dress, Strapless Dress, Tube Dress, Bodycon Dress, Sheath Dress, Shift Dress, A-Line Dress, Fit-and-Flare Dress, Ball Gown, Empire Waist Dress, Drop Waist Dress, Basque Waist Dress, Princess Seam Dress, Shirt Dress, T-Shirt Dress, Sweater Dress, Cardigan Dress, Wrap Dress, Surplice Dress, Jumpsuit, Romper, Playsuit, Overall Dress, Pinafore Dress, Jumper Dress, Coordinates Set, Matching Set, Two-Piece Dress

### **Outerwear**
- Jacket (Denim, Leather, Bomber, Biker, Moto, Track, Varsity, Letterman, Blazer, Sport Coat, Suit Jacket, Tuxedo Jacket, Tweed Jacket, Field Jacket, Safari Jacket, Utility Jacket, Chore Coat, Carhartt), Coat (Trench, Peacoat, Overcoat, Topcoat, Chesterfield, Ulster, Greatcoat, Duffel Coat, Toggle Coat, Wrap Coat, Cocoon Coat, Cape Coat), Raincoat, Windbreaker, Anorak, Parka, Puffer, Down Jacket, Puffer Jacket, Vest (Puffer Vest, Utility Vest, Suit Vest, Waistcoat, Sweater Vest), Cardigan Coat, Duster, Kimono Coat, Poncho Cape

### **Activewear & Sports-Specific**
- Sports Bra (Low Impact, Medium Impact, High Impact, Encapsulation, Compression, Racerback, Crossback), Leggings (Yoga, Running, Training, Studio), Shorts (Running, Basketball, Tennis, Golf, Training), Tops (Tank, Racerback, Crop Top, Long Sleeve, Quarter-Zip, Pullover), Tracksuit (Two-Piece, Three-Piece), Warm-Up Suit, Leotard, Unitard, Biketard, Dancewear, Figure Skating Dress, Gymnastics Leotard, Cheer Uniform, Yoga Set, Pilates Set, Barre Set, Spin Set, HIIT Set, CrossFit Set, Tennis Skirt, Golf Skirt, Skort

### **Swimwear & Beachwear**
- One-Piece Swimsuit, Bikini (Triangle, Bandeau, Halter, Underwire, Sport, High-Waisted, Low-Rise), Tankini, Monokini, Swim Dress, Board Shorts, Swim Trunks, Rash Guard, Wetsuit, Drysuit, Dive Skin, Beach Cover-Up (Sarong, Pareo, Kimono, Caftan, Tunic, Dress), Beach Pants, Beach Shorts, Beach Dress, Resort Wear, Cruise Wear

### **Intimates & Sleepwear**
- Bra (Underwire, Wire-Free, Push-Up, Plunge, Balconette, Demi, Full Coverage, Minimizer, Sports Bra, Nursing Bra, Maternity Bra, Mastectomy Bra, Post-Surgery Bra), Panties (Brief, Bikini, Hipster, Boyshort, Thong, G-String, Cheeky, High-Waisted, Control), Lingerie Set, Teddy, Bodysuit, Chemise, Babydoll, Robe, Kimono Robe, Dressing Gown, Nightgown, Sleep Shirt, Pajama Set (Two-Piece, Three-Piece), Lounge Set, Loungewear, Homewear, Underwear, Undershirt, Camisole, Slip (Half Slip, Full Slip), Shapewear (Control Brief, Control Shorts, Waist Cincher, Corset, Bustier, Bodysuit, Thigh Slimmer, Arm Shaper, Full Body Shaper), Hosiery (Pantyhose, Tights, Stockings, Thigh-Highs, Knee-Highs, Socks, Crew Socks, Ankle Socks, No-Show Socks, Compression Socks)

### **Specialized Categories**
- Adaptive Clothing (Wheelchair-Friendly, Seated Wear, Easy-Dress, Magnetic Closure, Velcro Closure, Front-Closure, Side-Closure), Maternity (Nursing-Friendly, Breastfeeding, Pumping-Friendly, Postpartum Recovery, C-Section Recovery, Belly Support, Back Support), Plus Size (Extended Sizing, Size Inclusive, Curve, Plus, Super Plus, Extended Plus), Petite, Tall, Big & Tall, Short, Long Torso, Short Torso, Athletic Build, Pregnancy, Postpartum, Nursing, Mastectomy, Post-Surgery, Medical (Surgical Scrubs, Hospital Gown, Patient Gown, Recovery Wear, Compression Garments), Uniform (School Uniform, Work Uniform, Military Uniform, Service Uniform, Chef Wear, Medical Scrubs), Costume (Theatrical, Cosplay, Halloween, Historical, Period, Fantasy, Sci-Fi), Ethnic & Cultural (Sari, Kimono, Hanbok, Abaya, Thobe, Kaftan, Dashiki, Cheongsam, Qipao)

---

## **4. Color (Hue & Pattern)**

### **Solid Colors (Core Palette)**
- Black, White, Off-White, Ivory, Cream, Beige, Tan, Camel, Taupe, Gray (Light Gray, Medium Gray, Charcoal Gray), Silver, Pewter, Navy, Midnight Blue, Royal Blue, Cobalt Blue, Sky Blue, Powder Blue, Teal, Turquoise, Aqua, Mint, Sage, Olive, Forest Green, Emerald, Kelly Green, Lime, Chartreuse, Yellow (Butter Yellow, Lemon Yellow, Canary Yellow), Gold, Mustard, Orange (Peach, Apricot, Coral, Salmon, Tangerine, Burnt Orange), Red (Crimson, Ruby, Scarlet, Cherry Red, Tomato Red, Brick Red), Pink (Blush, Rose, Dusty Pink, Millennial Pink, Hot Pink, Fuchsia, Magenta), Purple (Lavender, Lilac, Wisteria, Orchid, Plum, Eggplant, Violet, Amethyst, Mauve), Burgundy, Maroon, Oxblood, Wine, Rust, Terracotta, Copper, Bronze, Chocolate, Brown, Cognac

### **Color Families & Themes**
- Neutrals, Earth Tones, Jewel Tones, Pastels, Neon, Fluorescent, High-Visibility, Safety Colors, Camouflage, Military Colors, Nautical Colors, Preppy Colors, Earthy, Muted, Vibrant, Bold, Rich, Deep, Light, Dark, Pale, Soft, Dusty, Muddy, Saturated, Desaturated

### **Patterns & Prints**
- Solid, Heathered, Marled, Flecked, Slub, Variegated, Ombré, Gradient, Color Block, Tie-Dye, Dip-Dyed, Batik, Shibori, Ikat, Plaid, Tartan, Check, Gingham, Buffalo Check, Windowpane, Houndstooth, Herringbone, Tweed, Glen Plaid, Madras, Argyle, Fair Isle, Nordic, Scandinavian, Stripes (Horizontal, Vertical, Diagonal, Pinstripe, Breton Stripe, Cabana Stripe), Polka Dot, Floral (Ditsy Floral, Botanical, Tropical, English Garden, Rose Print, Liberty Print), Animal Print (Leopard, Cheetah, Zebra, Tiger, Snake, Python, Cow, Giraffe), Camouflage, Abstract, Geometric, Psychedelic, Art Deco, Art Nouveau, Baroque, Rococo, Paisley, Brocade, Damask, Toile, Chinoiserie, Tropical, Nautical, Coastal, Preppy, Western, Southwestern, Tribal, Ethnic, Bohemian, Skull, Gothic, Punk, Band Tee, Graphic, Logo, Monogram, Typography, Quote, Illustration, Pop Art, Comic Book, Cartoon, Anime, Manga, Kawaii, Harajuku, Decora, Lolita

### **Finish & Texture**
- Matte, Satin, Shiny, Glossy, Pearlescent, Iridescent, Holographic, Metallic (Gold, Silver, Bronze, Copper, Rose Gold), Foil, Glitter, Sequined, Beaded, Embroidered, Appliquéd, Padded, Quilted, Pintucked, Smocked, Ruched, Shirred, Pleated, Crushed, Wrinkled, Distressed, Ripped, Destroyed, Acid-Washed, Stone-Washed, Enzyme-Washed, Pigment-Dyed, Garment-Dyed, Dip-Dyed, Tie-Dyed, Bleached, Ombre, Gradient

---

## **5. Material (Fiber & Fabrication)**

### **Natural Fibers**
- **Cotton**: Cotton, Organic Cotton, Pima Cotton, Supima Cotton, Egyptian Cotton, Turkish Cotton, Sea Island Cotton, Upland Cotton, Short-Staple, Long-Staple, Combed Cotton, Ringspun Cotton, Slub Cotton, Recycled Cotton, Cradle to Cradle Cotton, BCI Cotton (Better Cotton Initiative)
- **Linen**: Linen, Belgian Linen, Irish Linen, French Linen, Organic Linen, Washed Linen, Slub Linen, Linen Blend
- **Silk**: Silk, Mulberry Silk, Charmeuse, Habotai, Crepe de Chine, Georgette, Chiffon, Organza, Taffeta, Dupioni, Shantung, Raw Silk, Noil, Peace Silk, Ahimsa Silk, Wild Silk, Tussah Silk, Eri Silk, Muga Silk
- **Wool**: Wool, Merino Wool, Cashmere, Lambswool, Virgin Wool, Shetland Wool, Icelandic Wool, Alpaca, Llama, Mohair, Angora, Camel Hair, Yak Wool, Qiviut, Vicuña, Recycled Wool, Responsible Wool Standard (RWS), ZQ Merino
- **Other Natural**: Hemp, Bamboo (Bamboo Viscose, Bamboo Lyocell), Jute, Ramie, Nettle, Kapok, Soy Protein Fiber, Milk Protein Fiber, Spider Silk, Lotus Fiber, Pineapple Leather (Piñatex), Apple Leather, Mushroom Leather (Mylo), Cactus Leather (Desserto), Cork, Leather (Full Grain, Top Grain, Corrected Grain, Split, Suede, Nubuck, Patent Leather, Exotic Leather), Shearling, Sheepskin, Cowhide, Goatskin, Pigskin, Deerskin, Elk Skin, Moose Leather, Alligator, Crocodile, Snake, Lizard, Ostrich, Emu, Fish Leather (Salmon, Cod, Tilapia), Fur (Mink, Fox, Chinchilla, Rabbit, Sable, Lynx), Faux Fur, Sherpa, Fleece (Natural), Down (Goose Down, Duck Down, Eiderdown), Feather, Silk Down

### **Synthetic & Man-Made Fibers**
- **Polyester**: Polyester, Recycled Polyester (rPET, PET from recycled bottles), Virgin Polyester, Performance Polyester, Moisture-Wicking Polyester, Quick-Dry Polyester, Antimicrobial Polyester, UV-Resistant Polyester, Ripstop Polyester, Taslan, Taffeta, Satin, Crepe, Chiffon, Georgette, Organza, Mesh, Tricot, Fleece (Polyester Fleece), Sherpa Fleece, Microfleece, Polar Fleece, Anti-Pill Fleece, Bonded Fleece, Hardface Fleece, Softshell, Hardshell, GORE-TEX, eVent, Pertex, NeoShell, Dermizax, Sympatex
- **Nylon**: Nylon, Recycled Nylon (Econyl), Ripstop Nylon, Cordura, Ballistic Nylon, Taslan, Supplex, Tactel, Anti-Pill Nylon, Stretch Nylon
- **Spandex/Elastane**: Spandex, Elastane, Lycra, Elaspan, Dorlastan, Linel, Recycled Spandex, Bio-Based Spandex
- **Acrylic**: Acrylic, Modacrylic, Recycled Acrylic, Anti-Pill Acrylic, Soft Acrylic
- **Rayon/Viscose**: Rayon, Viscose, Modal (Lenzing Modal, MicroModal), Lyocell (Tencel, Tencel Luxe, Tencel x Refibra), Cupro (Bemberg), Acetate, Triacetate, Cellulose Acetate, Recycled Cellulose
- **Other Synthetics**: Polypropylene, Neoprene, Scuba, Ponte, Techno Fabric, Power Mesh, Power Net, Illusion Mesh, Tulle, Netting, Organza, Crinoline, Horsehair Braid, Stay Tape, Fusing, Interfacing, Lining, Tricot Lining, Bemberg Lining, Acetate Lining, Stretch Lining

### **Fabric Construction & Weave**
- Woven (Plain Weave, Twill Weave, Satin Weave, Dobby, Jacquard, Leno, Oxford, Pinpoint, Royal Oxford, Chambray, Denim, Corduroy, Velvet, Velveteen, Velour, Faille, Broadcloth, Poplin, Lawn, Voile, Batiste, Muslin, Canvas, Duck, Sailcloth, Ripstop, Serge, Gabardine, Flannel, Sharkskin, Houndstooth, Herringbone, Tweed, Bouclé, Lurex, Metallic Thread), Knit (Jersey, Interlock, Rib Knit, Ponte, Double Knit, French Terry, Fleece, Sweater Knit, Cable Knit, Fair Isle, Intarsia, Jacquard Knit, Pointelle, Lace Knit, Mesh Knit, Illusion Knit, Stretch Knit, Compression Knit, Seamless, Full Fashion, Cut and Sew), Non-Woven (Felt, Interfacing, Fusible, Fleece, Wadding, Batting, Fiberweb, Spunbond, Meltblown), Leather (Full Grain, Top Grain, Corrected Grain, Split, Bonded Leather), Fur (Shearling, Sheepskin, Mouton, Rex Rabbit, Fox, Mink)

### **Sustainable & Eco-Friendly Certifications**
- GOTS (Global Organic Textile Standard), OEKO-TEX Standard 100, OEKO-TEX Made in Green, OEKO-TEX STeP, Bluesign, Cradle to Cradle Certified, Higg Index, Fair Trade Certified, SA8000, B Corp, PETA-Approved Vegan, Vegan Society, Leaping Bunny, Responsible Wool Standard (RWS), Responsible Down Standard (RDS), Responsible Alpaca Standard (RAS), Responsible Mohair Standard (RMS), Forest Stewardship Council (FSC), Recycled Claim Standard (RCS), Global Recycled Standard (GRS), Organic Content Standard (OCS), Content Claim Standard (CCS), BioPreferred, USDA Organic, EU Ecolabel, Nordic Swan Ecolabel

---

## **6. Season (Weather & Temporal Context)**

### **Seasonal Categories**
- Spring, Summer, Autumn, Fall, Winter, All-Season, Year-Round, Transitional, Resort, Cruise, Pre-Spring, Pre-Fall, Holiday, Festive, New Year, Valentine's Day, Easter, Fourth of July, Halloween, Thanksgiving, Christmas, Hanukkah, New Year's Eve

### **Weather-Specific**
- Hot Weather, Tropical, Desert, Humid, Dry, Rainy Season, Monsoon, Storm, Hurricane, Tornado, Blizzard, Snow, Ice, Sleet, Hail, Frost, Freezing, Sub-Zero, Arctic, Polar, Temperate, Mediterranean, Coastal, Mountain, Highland, Valley, Urban Heat Island, Indoor Climate Controlled, Outdoor, Variable Conditions

### **Temperature & Climate Tech**
- Lightweight, Midweight, Heavyweight, Thermal, Insulated, Down-Filled, Synthetic Insulation, Heated (Battery Heated, USB Heated), Cooling (Cooling Technology, Ice-Fil, ClimaCool), Breathable, Ventilated, Airy, Sheer, Gauzy, Open-Weave, Mesh, Moisture-Wicking, Quick-Dry, Sun-Protective, UPF 50+, UV Protection, Windproof, Wind-Resistant, Water-Resistant, Waterproof, Weatherproof, All-Weather, Stormproof

---

## **7. Fit & Body Type (Sizing & Silhouette)**

### **Size Ranges & Standards**
- **Standard Numeric**: XXS, XS, S, M, L, XL, XXL, XXXL, 4XL, 5XL, 6XL, 7XL, 8XL, 00, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32
- **Alpha-Numeric**: 2XS, XS, S, M, L, XL, 2XL, 3XL, 4XL, 5XL, 6XL, 7XL, 8XL
- **Women's Specific**: Misses, Petites, Tall, Women's (Plus), Junior, Contemporary, Modern, Curvy, Super Curvy, Extra Curvy
- **Men's Specific**: Short, Regular, Long, Extra Long, Big, Tall, Big & Tall, Athletic Fit, Slim Fit, Modern Fit, Classic Fit, Traditional Fit, Husky
- **International Conversions**: US, UK, EU, IT, FR, DE, JP, CN, AU, KR, BR, MX

### **Body Shape & Silhouette**
- Apple Shape, Pear Shape, Hourglass, Inverted Triangle, Rectangle, Oval, Diamond, Spoon, Top Hourglass, Bottom Hourglass, Athletic Build, Muscular Build, Lean Build, Slender, Slim, Average, Curvy, Full-Figured, Heavyset, Stocky, Broad-Shouldered, Narrow-Shouldered, Long Torso, Short Torso, Long Legs, Short Legs, High Waist, Low Waist, Proportionate, Disproportionate, Plus Size, Super Size, Extended Size, Petite Plus, Tall Plus

### **Fit Descriptors**
- Compression, Fitted, Slim Fit, Contoured, Tailored, Close-Fitting, Bodycon, Second Skin, Sheath, Semi-Fitted, Regular Fit, Classic Fit, Normal Fit, Traditional Fit, Average Fit, Relaxed Fit, Easy Fit, Comfort Fit, Loose Fit, Oversized, Boxy, Boyfriend, Girlfriend, Dad Fit, Mom Fit, Heritage Fit, Vintage Fit, Cropped, Longline, Tunic Length, Asymmetrical, High-Low, Hi-Lo, Handkerchief Hem, Shark Bite Hem, Tulip Hem, Bubble Hem, Balloon Hem, Cocoon, Trapeze, Swing, A-Line, Fit-and-Flare, Empire Waist, Drop Waist, Basque Waist, Princess Seam, Wiggle, Pencil, Sheath, Shift, Slip, Column, Maxi, Midi, Mini, Micro, Knee-Length, Tea-Length, Ankle-Length, Floor-Length, Ballerina Length, Street Length, Cocktail Length

### **Specialty Fit Categories**
- Maternity (Belly Panel, Under Belly, Over Belly, Side Ruched, Front Ruched, Wrap, Empire Waist, Drop Waist), Nursing (Nursing-Friendly, Breastfeeding, Pumping-Friendly, Clip-Down, Pull-Aside, Wrap, Button-Front), Postpartum (C-Section Recovery, Diastasis Recti Support, Tummy Control, Compression, High-Waisted), Adaptive (Wheelchair-Friendly, Seated Design, Easy-Dress, Magnetic Closure, Velcro, Snap, Side-Opening, Back-Opening, Front-Opening, No-Tag, Sensory-Friendly), Medical (Post-Surgery, Mastectomy, Lymphedema, Compression, Orthopedic, Bariatric)

---

## **Implementation Notes**

**Total Combinational Potential**: 50+ styles × 80+ occasions × 120+ categories × 150+ colors × 100+ materials × 30+ seasons × 50+ fits = **108,000,000,000+ unique tag combinations**

**Recommended Usage**:
- **E-commerce**: Use 5-8 tags per product for optimal searchability
- **PIM Systems**: Implement as hierarchical taxonomy with controlled vocabulary
- **AI/ML**: Leverage for vector-based similarity scoring and recommendation algorithms
- **SEO**: Combine tags into long-tail keywords (e.g., "bohemian plus size maxi dress summer wedding guest")

**Source Standards**: This taxonomy aligns with GS1, ASTM D3666, and ISO 22763 standards for textile classification, while incorporating contemporary fashion taxonomy from leading retailers and trend forecasting agencies (WGSN, Edited, Heuritech).