# Shopee API 爬虫 - 使用说明

## ✅ 已完成的工作

1. **爬虫脚本**: `shopee_crawler.py` - 主爬虫程序
2. **测试脚本**: `test_crawler.py` - 测试用（爬取前5个）
3. **查询词文件**: `queries.txt` - 5024个搜索关键词
4. **使用文档**: `README.md` - 详细使用说明

## 📂 目录结构

```
data_crawling/
├── shopee_crawler.py          # 主爬虫脚本
├── test_crawler.py            # 测试脚本
├── queries.txt                # 5024个查询词
├── 万邦API_shopee.md          # API文档
├── README.md                  # 详细说明
├── 使用说明.md                # 本文件
├── shopee_results/            # 正式爬取结果目录
└── test_results/              # 测试结果目录
```

## ⚠️ 重要提示

**当前API账号状态**:
- ✗ Shopee接口未开通（需要联系万邦API开通）
- API Key: `t8618339029`
- 每日限额: 50次
- 到期时间: 2025-12-06

**开通方式**:
- QQ: 3142401606
- 微信: onebound1997
- 文档: https://open.onebound.cn/help/api/shopee.item_search.html

## 🚀 快速开始

### 1. 测试运行（推荐）

```bash
cd /home/tw/SearchEngine/data_crawling
python test_crawler.py
```

这会测试前5个查询词，确认脚本功能正常。

### 2. 正式运行

**开通API权限后**，运行完整爬取：

```bash
python shopee_crawler.py
```

这会爬取全部5024个查询词。

## 📊 脚本功能

### 主要特性

- ✅ 自动读取查询词文件
- ✅ 逐个请求API并保存JSON结果
- ✅ 自动重试失败的请求（最多3次）
- ✅ 控制请求频率（默认2秒间隔）
- ✅ 保存爬取摘要和失败列表
- ✅ 实时显示进度和统计信息

### 输出文件

每个查询词会生成一个JSON文件：

```
0001_Bohemian_Maxi_Dress_20231204_151203.json
0002_Vintage_Denim_Jacket_20231204_151206.json
...
```

### 摘要文件

`summary.json` 包含完整的爬取统计：

```json
{
  "crawl_time": "2023-12-04T15:12:03",
  "total": 5024,
  "success": 5000,
  "fail": 24,
  "elapsed_seconds": 20480,
  "config": {
    "country": ".com.my",
    "page": 1,
    "delay": 2
  },
  "failed_queries": ["query1", "query2"]
}
```

## ⚙️ 配置修改

编辑 `shopee_crawler.py` 顶部的配置：

```python
# 站点选择
COUNTRY = '.com.my'  # 可选: .vn, .co.th, .tw, .co.id, .sg

# 爬取页码
PAGE = 1  # 第几页

# 请求间隔（秒）
DELAY = 2  # 建议2-5秒

# 最大重试次数
MAX_RETRIES = 3
```

## 📈 预估时间和资源

### 时间预估

- 单个查询: ~4秒（API请求2秒 + 延迟2秒）
- 5024个查询: ~5.6小时

### 资源需求

- 磁盘空间: ~2-3 GB（取决于每个查询返回的商品数量）
- 内存: 最小256MB
- 网络: 稳定的互联网连接
- API配额: 至少5024次调用额度

## 📝 使用示例

### 场景1: 测试API是否可用

```bash
python test_crawler.py
```

查看 `test_results/` 目录，检查JSON文件内容。

### 场景2: 爬取特定数量

修改 `shopee_crawler.py` 的 `main()` 函数：

```python
# 只爬取前100个
queries = queries[:100]
```

### 场景3: 更换站点

修改脚本顶部：

```python
COUNTRY = '.sg'  # 改为新加坡站
```

### 场景4: 中断后继续

1. 查看已爬取的数量：`ls shopee_results/*.json | wc -l`
2. 删除 `queries.txt` 中已完成的查询词
3. 重新运行脚本

## 🔧 故障排除

### 问题1: API权限错误

```
✗ API错误: shopee无权访问,请开通接口
```

**解决**: 联系万邦API开通Shopee接口权限。

### 问题2: 网络超时

```
✗ 请求失败: Connection timeout
```

**解决**: 
- 检查网络连接
- 增加超时时间（修改 `timeout=30` 参数）
- 增加重试次数

### 问题3: API配额用完

```
✗ API错误: 超过每日限额
```

**解决**:
- 等待第二天重置
- 或升级API套餐

### 问题4: 文件保存错误

```
✗ 保存失败: Permission denied
```

**解决**:
- 检查目录权限: `chmod 755 shopee_results`
- 检查磁盘空间: `df -h`

## 📞 技术支持

### API提供商

- **万邦API**
- QQ: 3142401606
- 微信: onebound1997
- 官网: https://open.onebound.cn

### 脚本相关

查看以下文件：
- `README.md` - 详细文档
- `test_results/` - 测试结果示例
- API文档: `万邦API_shopee.md`

## ✨ 后续优化建议

1. **断点续爬**: 记录已完成的查询词，支持中断后继续
2. **多线程**: 使用多线程并发请求（注意API限流）
3. **数据解析**: 从JSON中提取关键字段，存入数据库
4. **统计分析**: 分析商品价格、销量分布等
5. **定时任务**: 使用crontab设置定期爬取

## 🎯 使用流程总结

```bash
# 步骤1: 开通API权限
# 联系万邦API开通Shopee接口

# 步骤2: 测试
cd /home/tw/SearchEngine/data_crawling
python test_crawler.py

# 步骤3: 检查测试结果
cat test_results/0001_Bohemian_Maxi_Dress.json

# 步骤4: 正式爬取
python shopee_crawler.py

# 步骤5: 查看结果
ls -lh shopee_results/
cat shopee_results/summary.json
```

---

**创建时间**: 2023-12-04  
**脚本版本**: v1.0  
**Python版本**: 3.6+

