#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
API配置文件示例
复制此文件为 config.py 并填入真实的API密钥
"""

# 万邦API配置
API_KEY = "your_api_key_here"
API_SECRET = "your_api_secret_here"

# 爬取配置
CRAWL_CONFIG = {
    # 请求间隔时间（秒），避免请求过快
    'delay': 2.0,
    
    # 起始索引（用于断点续爬）
    'start_index': 0,
    
    # 最大爬取数量（None表示全部）
    'max_queries': None,
    
    # 其他API参数
    'cache': 'yes',  # 是否使用缓存
    'result_type': 'json',  # 返回格式
    'lang': 'cn',  # 语言
}

