"""
Context module for request-level context management.

This module provides the RequestContext class for managing search request context,
including query analysis results, intermediate results, and performance metrics.
"""

from .request_context import (
    RequestContext,
    RequestContextStage,
    QueryAnalysisResult,
    PerformanceMetrics,
    create_request_context,
    get_current_request_context,
    set_current_request_context,
    clear_current_request_context
)

__all__ = [
    'RequestContext',
    'RequestContextStage',
    'QueryAnalysisResult',
    'PerformanceMetrics',
    'create_request_context',
    'get_current_request_context',
    'set_current_request_context',
    'clear_current_request_context'
]