"""
Configuration package for search engine.

Provides configuration loading, validation, and utility functions.
"""

from .config_loader import (
    SearchConfig,
    QueryConfig,
    IndexConfig,
    SPUConfig,
    RankingConfig,
    FunctionScoreConfig,
    RerankConfig,
    ConfigLoader,
    ConfigurationError,
    load_tenant_config
)

from .utils import (
    get_match_fields_for_index,
    get_domain_fields
)

__all__ = [
    # Main config classes
    'SearchConfig',
    'QueryConfig',
    'IndexConfig',
    'SPUConfig',
    'RankingConfig',
    'FunctionScoreConfig',
    'RerankConfig',
    
    # Loader and utilities
    'ConfigLoader',
    'ConfigurationError',
    'load_tenant_config',
    'get_match_fields_for_index',
    'get_domain_fields',
]
