# 电商搜索引擎 SaaS

一个针对跨境独立站（店匠 Shoplazza 等）的多租户可配置搜索平台。README 作为项目导航入口，帮助你在不同阶段定位到更详细的文档。


## 项目环境
source /home/tw/miniconda3/etc/profile.d/conda.sh
conda activate searchengine
source .env

## 测试pipeline

fake数据 生成商品导入数据 提交到店匠的店铺：
cd /home/tw/SearchEngine && source /home/tw/miniconda3/etc/profile.d/conda.sh && conda activate searchengine && python scripts/csv_to_excel_multi_variant.py --output  with_colors.xlsx 

自动同步到mysql
mysql到ES：

python scripts/recreate_and_import.py \
    --tenant-id 162 \
    --db-host <mysql_host> \
    --db-database saas \
    --db-username saas \
    --db-password <password> \
    --es-host http://localhost:9200

构造查询：
参考 @常用查询 - ES.md


## 核心能力速览

- **多语言 + 自动翻译**：中文、英文、俄文等语言检测与路由（BGE-M3、DeepL）
- **语义 + 关键词混排**：BM25、dense vector（BGE-M3/CN-CLIP）融合
- **布尔与分面**：AND / OR / ANDNOT / RANK、Terms & Range facets
- **多租户隔离**：共享 `search_products` 索引，通过 `tenant_id` 严格隔离
- **可配置化**：字段/索引域/排序表达式/查询改写全部配置驱动
- **脚本化流水线**：Mock/CSV 数据 → MySQL → Elasticsearch → API/前端

## 快速上手（概览）

| 步骤 | 去哪里看 | 摘要 |
|------|---------|------|
| 1. 准备环境 | `环境配置说明.md` / `Usage-Guide.md` | Conda/依赖、Elasticsearch、MySQL、必需变量 |
| 2. 构造测试数据 | `测试数据指南.md` | Tenant1 Mock、Tenant2 CSV、`mock_data.sh` / `ingest.sh` |
| 3. 启动与验证 | `Usage-Guide.md` | `run.sh` 一键启动、分步脚本、日志与健康检查 |
| 4. 理解架构 | `系统设计文档.md` | 数据流、配置系统、查询/搜索/索引模块 |
| 5. 接入搜索 API | `搜索API对接指南.md` / `搜索API速查表.md` | REST 端点、参数、响应、最佳实践 |
| 6. 查字段定义 | `索引字段说明.md` | `search_products` 映射、字段来源、类型与用途 |

> README 仅保留最常用命令的“索引”。细节以主题文档为准。

### Runtimes & 命令示例

```bash
# 1. 安装依赖与准备服务
pip install -r requirements.txt                      # 详见 USAGE_GUIDE.md
docker run -d --name es -p 9200:9200 elasticsearch:8.11.0

# 2. 构造测试数据并导入 MySQL
./scripts/mock_data.sh                               # 详见 TEST_DATA_GUIDE.md

# 3. 从 MySQL 注入到 Elasticsearch
./scripts/ingest.sh 1 true
./scripts/ingest.sh 2 true

# 4. 启动服务
./run.sh

# 5. 调用文本搜索 API
curl -X POST http://localhost:6002/search/ \
  -H "Content-Type: application/json" \
  -H "X-Tenant-ID: 1" \
  -d '{"query": "玩具", "size": 10}'
```

## 文档地图

| 文档 | 内容提要 | 适用场景 |
|------|----------|----------|
| `环境配置说明.md` | 系统要求、Conda/依赖、外部服务账号、常用端口 | 首次部署、环境核对 |
| `Usage-Guide.md` | 环境准备、服务启动、配置、日志、验证手册 | 日常运维、调试 |
| `基础配置指南.md` | 统一硬编码配置说明、索引结构、查询配置 | 了解系统配置、修改配置 |
| `测试数据指南.md` | 两个租户的模拟/CSV 数据构造 & MySQL→ES 流程 | 数据准备、联调 |
| `测试Pipeline说明.md` | 测试流水线、CI 脚本、上下文说明 | 自动化测试、追踪流水线 |
| `系统设计文档.md` | 架构、配置系统、索引/查询/排序模块细节 | 研发/扩展功能 |
| `索引字段说明v2.md` | `search_products` 字段、类型、来源、嵌套结构 | 新增字段、数据对齐 |
| `搜索API对接指南.md` | REST API（文本/图片/管理）详解、示例、响应格式 | API 使用、测试 |
| `搜索API速查表.md` | 常用请求体、过滤器、分面速查表 | 支持团队快速查阅 |
| `Search-API-Examples.md` | Python/JS/cURL 端到端示例 | 客户工程、SDK 参考 |
| `环境配置说明.md` + `.env` 模板 | 运行依赖账号、端口、密钥对照表 | 交付 & 运维 |

更多补充材料：

- `测试数据指南.md`：包含完整工作流脚本示例
- `商品数据源入ES配置规范.md`：数据源映射约定
- `MULTILANG_FEATURE.md`：多语言处理细节

## 关键工作流指引

- **数据构建 → MySQL → Elasticsearch**  
  - `scripts/mock_data.sh`：Tenant1 Mock + Tenant2 CSV 一条龙  
  - `scripts/ingest.sh <tenant_id> [recreate]`：驱动 `indexer/` 模块写入 `search_products`
  - 详解：`测试数据指南.md`

- **搜索服务 & API**  
  - `api/`（FastAPI）承载 REST API，`search/` + `query/` 负责查询解析与下发  
  - API、分页、过滤、Facet、KNN 等：`搜索API对接指南.md`
  - 对接案例、示例与错误码：`搜索API对接指南.md`、`Search-API-Examples.md`

- **统一配置**  
  - 所有租户共享统一的索引结构和查询配置（硬编码）  
  - 索引 mapping: `mappings/search_products.json`  
  - 查询配置: `search/query_config.py`  
  - 详解：`基础配置指南.md`、`索引字段说明v2.md`

## 仓库结构（概览）

```
api/            FastAPI 服务与路由
config/         字段/索引/查询配置体系
indexer/        MySQL → ES 管道（mapping / transformer / bulk）
query/          查询解析、改写、翻译、embedding
search/         多语言构建、布尔解析、排序引擎
scripts/        数据/服务脚本（mock_data, ingest, run 等）
frontend/       简易调试页面
docs/           运营及中文资料
```
