<!-- d9d0ef58-7a33-4ef6-8e3a-714b4552fd20 56c8cc4b-4eeb-4b77-9986-f4fa349e96b9 -->
# 多租户架构重构计划

## 概述

将搜索服务从按租户启动改造为真正的多租户架构：

- 服务启动时不指定租户ID，所有租户共用一套配置
- 删除tenant1配置，去掉base层级，统一为config.yaml
- 统一脚本接口：启动、停止、重启、数据灌入
- 统一数据灌入流程，ES只有一份索引
- 前端支持在搜索框左侧输入租户ID

## Phase 1: 配置文件体系重构

### 1.1 创建统一配置文件

**文件**: `config/config.yaml` (NEW)

- 将 `config/schema/base/config.yaml` 移动到 `config/config.yaml`
- 删除 `tenant_name` 字段（不再需要）
- 删除 `tenant_id` 相关逻辑
- 固定索引名称为 `search_products`
- 确保包含 `tenant_id` 字段（必需）

### 1.2 删除tenant1配置

**删除文件**:

- `config/schema/tenant1/config.yaml`
- `config/schema/tenant1/` 目录（如果为空）

### 1.3 更新ConfigLoader

**文件**: `config/config_loader.py`

修改 `load_tenant_config()` 方法：

- 移除 `tenant_id` 参数
- 改为 `load_config()` 方法
- 直接加载 `config/config.yaml`
- 移除对 `config/schema/{tenant_id}/config.yaml` 的查找逻辑
- 移除 `tenant_id` 字段验证
- 更新 `TenantConfig` 类：移除 `tenant_id` 字段

### 1.4 更新配置验证

**文件**: `config/config_loader.py`

修改 `validate_config()` 方法：

- 确保 `tenant_id` 字段存在且为必需
- 移除对 `tenant_id` 的验证

## Phase 2: 服务启动改造

### 2.1 更新API应用初始化

**文件**: `api/app.py`

修改 `init_service()` 方法：

- 移除 `tenant_id` 参数
- 直接加载统一配置（`config/config.yaml`）
- 移除 `TENANT_ID` 环境变量依赖
- 更新日志输出（不再显示tenant_id）

修改 `startup_event()` 方法：

- 移除 `TENANT_ID` 环境变量读取
- 直接调用 `init_service()` 不传参数

### 2.2 更新main.py

**文件**: `main.py`

修改 `cmd_serve()` 方法：

- 移除 `--tenant` 参数
- 移除 `TENANT_ID` 环境变量设置
- 更新帮助信息

### 2.3 更新启动脚本

**文件**: `scripts/start_backend.sh`

修改：

- 移除 `TENANT_ID` 环境变量
- 移除 `--tenant` 参数
- 简化启动命令

**文件**: `scripts/start_servers.py`

修改 `start_api_server()` 方法：

- 移除 `tenant` 参数
- 移除 `TENANT_ID` 环境变量设置
- 简化启动命令

## Phase 3: 脚本体系统一

### 3.1 创建统一启动脚本

**文件**: `scripts/start.sh` (NEW)

功能：

- 启动后端服务（调用 `scripts/start_backend.sh`）
- 启动前端服务（调用 `scripts/start_frontend.sh`）
- 等待服务就绪
- 显示服务状态和访问地址

### 3.2 创建统一停止脚本

**文件**: `scripts/stop.sh` (已存在，需更新)

功能：

- 停止后端服务（端口6002）
- 停止前端服务（端口6003）
- 清理PID文件
- 显示停止状态

### 3.3 创建统一重启脚本

**文件**: `scripts/restart.sh` (已存在，需更新)

功能：

- 调用 `scripts/stop.sh` 停止服务
- 等待服务完全停止
- 调用 `scripts/start.sh` 启动服务

### 3.4 创建数据灌入脚本

**文件**: `scripts/ingest.sh` (已存在，需更新)

功能：

- 从MySQL读取数据
- 转换数据格式（统一处理base和tenant1数据源）
- 灌入到ES索引 `search_products`
- 支持指定租户ID过滤数据
- 自动处理字段映射：缺失字段随机生成，多余字段忽略

### 3.5 创建Mock数据脚本

**文件**: `scripts/mock_data.sh` (NEW)

功能：

- 生成测试数据到MySQL
- 支持指定租户ID
- 支持指定数据量
- 调用 `scripts/generate_test_data.py` 和 `scripts/import_test_data.py`

### 3.6 更新根目录脚本

**文件**: `run.sh` (已存在，需更新)

功能：

- 调用 `scripts/start.sh` 启动服务

**文件**: `restart.sh` (已存在，需更新)

功能：

- 调用 `scripts/restart.sh` 重启服务

**文件**: `setup.sh` (已存在，需更新)

功能：

- 设置环境
- 检查依赖
- 不包含服务启动逻辑

**文件**: `test_all.sh` (已存在，需更新)

功能：

- 运行完整测试流程
- 包含数据灌入、服务启动、API测试

### 3.7 清理废弃脚本

**删除文件**:

- `scripts/demo_base.sh`
- `scripts/stop_base.sh`
- `scripts/start_test_environment.sh`
- `scripts/stop_test_environment.sh`
- 其他不再需要的脚本

## Phase 4: 数据灌入统一

### 4.1 更新数据灌入脚本

**文件**: `scripts/ingest_shoplazza.py`

修改：

- 移除 `--config` 参数（不再需要）
- 直接加载统一配置（`config/config.yaml`）
- 统一处理所有数据源（不再区分base和tenant1）
- 支持 `--tenant-id` 参数过滤数据
- 字段映射逻辑：
- 如果字段在配置中但数据源中没有，随机生成
- 如果字段在数据源中但配置中没有，忽略
- 确保 `tenant_id` 字段正确设置

### 4.2 更新数据转换器

**文件**: `indexer/spu_transformer.py`

修改：

- 移除对配置中 `tenant_id` 的依赖
- 统一处理所有数据源
- 确保字段映射正确（缺失字段随机生成，多余字段忽略）

### 4.3 统一测试数据生成

**文件**: `scripts/generate_test_data.py`

修改：

- 支持生成符合统一索引结构的测试数据
- 支持指定租户ID
- 确保生成的数据包含所有必需字段

## Phase 5: 前端改造

### 5.1 更新前端HTML

**文件**: `frontend/index.html`

修改：

- 在搜索框左侧添加租户ID输入框
- 添加租户ID标签
- 更新布局样式

### 5.2 更新前端JavaScript

**文件**: `frontend/static/js/app_base.js`

修改：

- 移除硬编码的 `TENANT_ID = '1'`
- 从输入框读取租户ID
- 在搜索请求中发送租户ID（通过 `X-Tenant-ID` header）
- 添加租户ID验证（不能为空）
- 更新UI显示

### 5.3 更新前端CSS

**文件**: `frontend/static/css/style.css`

修改：

- 添加租户ID输入框样式
- 更新搜索栏布局（支持租户ID输入框）

## Phase 6: 更新文档和测试

### 6.1 更新README

**文件**: `README.md`

修改：

- 更新启动说明（不再需要指定租户ID）
- 更新配置说明（统一配置文件）
- 更新脚本使用说明

### 6.2 更新API文档

**文件**: `API_DOCUMENTATION.md`

修改：

- 更新租户ID说明（必须通过请求提供）
- 更新配置说明（统一配置）

### 6.3 更新测试脚本

**文件**: `test_all.sh`

修改：

- 更新测试流程（不再需要指定租户ID）
- 更新数据灌入测试（统一数据源）
- 更新API测试（包含租户ID参数）

## Phase 7: 清理和验证

### 7.1 清理废弃代码

- 删除所有对 `tenant_id` 的引用
- 删除所有对 `tenant1` 配置的引用
- 删除所有对 `base` 配置层级的引用
- 清理不再使用的脚本

### 7.2 验证功能

- 验证服务启动（不指定租户ID）
- 验证配置加载（统一配置）
- 验证数据灌入（统一数据源）
- 验证搜索功能（通过请求提供租户ID）
- 验证前端功能（租户ID输入）

## 关键文件清单

### 需要修改的文件：

1. `config/config_loader.py` - 移除tenant_id逻辑
2. `config/config.yaml` - 统一配置文件（从base移动）
3. `api/app.py` - 移除tenant_id参数
4. `main.py` - 移除tenant参数
5. `scripts/start_backend.sh` - 移除TENANT_ID
6. `scripts/start_servers.py` - 移除tenant参数
7. `scripts/ingest_shoplazza.py` - 统一数据灌入
8. `frontend/index.html` - 添加租户ID输入框
9. `frontend/static/js/app_base.js` - 读取租户ID
10. `run.sh`, `restart.sh`, `setup.sh`, `test_all.sh` - 更新脚本

### 需要删除的文件：

1. `config/schema/tenant1/config.yaml`
2. `config/schema/tenant1/` 目录
3. `scripts/demo_base.sh`
4. `scripts/stop_base.sh`
5. 其他废弃脚本

### 需要创建的文件：

1. `config/config.yaml` - 统一配置文件
2. `scripts/start.sh` - 统一启动脚本
3. `scripts/mock_data.sh` - Mock数据脚本